<?php
session_start();
require_once "config.php"; // ensure this connects to $link

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize inputs
    $phone_number = trim($_POST['phone_number']);
    $password = trim($_POST['password']);
    $first_name = trim($_POST['first_name']);
    $last_name = trim($_POST['last_name']);
    $email_address = trim($_POST['email_address']);
    $sponsor_id = trim($_POST['sponsor_id']);

    $country_of_interest = trim($_POST['country_of_interest']);
    $state_of_origin = trim($_POST['state_of_origin']);
    $nin = trim($_POST['nin']);
    $marital_status = trim($_POST['marital_status']);
    $dob = trim($_POST['dob']);

    // Security checks (optional: further validation here)
    if (!filter_var($email_address, FILTER_VALIDATE_EMAIL)) {
        die("Invalid email address.");
    }

    // Generate unique member ID
    $member_id = substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, 10);

    // Set default values for wallet and status fields
    $main_wallet = '';
    $earning_wallet = '';
    $email_verification_status = '';
    $payment_status = '';

    // Prepare and execute INSERT statement
    $sql = "INSERT INTO members (
        phone_number, password, first_name, last_name, email_address,
        member_id, sponsor_id, main_wallet, earning_wallet, email_verification_status,
        payment_status, country_of_interest, state_of_origin, nin, marital_status, dob
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    if ($stmt = mysqli_prepare($link, $sql)) {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        mysqli_stmt_bind_param($stmt, "ssssssssssssssss",
            $phone_number,
            $hashed_password,
            $first_name,
            $last_name,
            $email_address,
            $member_id,
            $sponsor_id,
            $main_wallet,
            $earning_wallet,
            $email_verification_status,
            $payment_status,
            $country_of_interest,
            $state_of_origin,
            $nin,
            $marital_status,
            $dob
        );

        if (mysqli_stmt_execute($stmt)) {
            // Redirect to email verification or confirmation page
            ?>
            <script>
                window.location.assign("registration_email_notification.php?sponsor=<?php echo $sponsor_id; ?>&email=<?php echo $email_address; ?>&code=<?php echo $member_id; ?>&username=<?php echo $first_name; ?>");
            </script>
            <?php
        } else {
            echo "Error executing statement: " . mysqli_stmt_error($stmt);
        }

        mysqli_stmt_close($stmt);
    } else {
        echo "Error preparing statement: " . mysqli_error($link);
    }
}
?>



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Register</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #2980b9, #6dd5fa);
      margin: 0;
      padding: 0;
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
    }

    .container {
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 0 15px rgba(0,0,0,0.2);
      padding: 0 30px 30px 30px;
      max-width: 400px;
      width: 90%;
      position: relative;
      overflow: hidden;
    }

    .container img {
      display: block;
      width: 100%;
      max-width: 250px;
      height: auto;
      margin: 0 auto;
      border-top-left-radius: 15px;
      border-top-right-radius: 15px;
    }

    .container h4 {
      background-color: #2980b9;
      color: #fff;
      padding: 10px 15px;
      border-radius: 8px;
      text-align: center;
      margin: 15px 0;
    }

    .form-group {
      margin-bottom: 15px;
      position: relative;
    }

    .form-group input {
      width: 100%;
      padding: 10px 35px 10px 35px;
      border: 1px solid #ccc;
      border-radius: 8px;
      outline: none;
      transition: 0.3s;
      box-sizing: border-box;
    }

    .form-group input:focus {
      border-color: #2980b9;
      box-shadow: 0 0 5px rgba(41, 128, 185, 0.5);
    }

    .form-group .input-icon {
      position: absolute;
      left: 10px;
      top: 50%;
      transform: translateY(-50%);
      color: #2980b9;
      pointer-events: none;
    }

    .form-group .toggle-password {
      position: absolute;
      right: 10px;
      top: 50%;
      transform: translateY(-50%);
      cursor: pointer;
      color: #999;
    }

    .form-check {
      margin-bottom: 15px;
    }

    .btn {
      padding: 10px;
      width: 100%;
      margin-top: 10px;
      border: none;
      border-radius: 8px;
      background: #2980b9;
      color: white;
      font-weight: bold;
      cursor: pointer;
    }

    .btn:hover {
      background: #2471a3;
    }

    .form-note {
      text-align: center;
      margin-top: 10px;
    }

    .preloader-bar {
      height: 5px;
      background: #2980b9;
      animation: loading 2s infinite;
      border-radius: 0 0 8px 8px;
    }

    @keyframes loading {
      0% { width: 0; }
      50% { width: 50%; }
      100% { width: 100%; }
    }

    .page-loader {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(255,255,255,0.9);
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 9999;
      display: none;
    }

    .spinner {
      width: 60px;
      height: 60px;
      border: 6px solid #ccc;
      border-top-color: #2980b9;
      border-radius: 50%;
      animation: spin 1s linear infinite;
    }

    @keyframes spin {
      to {
        transform: rotate(360deg);
      }
    }
  </style>
</head>


<body>
  <div class="container">
    <img src="logoc.png" alt="Logo">
    <div class="preloader-bar"></div>
    <h4>Register</h4>

    <form onsubmit="showLoader()" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">
        
<div style="color:red; font-size:17px; text-align:center;margin-top:15px;"> 	
 <?php echo @$password_err;?>
 <?php echo @$phone_number_err;?>
 <?php echo @$linkfirm_password_err;?>
 <?php echo @$email_address_err;?>
</div>

      <div class="form-group"><i class="fas fa-user input-icon"></i>
        <input type="text" name="first_name" placeholder="First Name" required>
      </div>
      <div class="form-group"><i class="fas fa-user input-icon"></i>
        <input type="text" name="last_name" placeholder="Last Name" required>
      </div>
      <div class="form-group"><i class="fas fa-phone input-icon"></i>
        <input type="number" name="phone_number" placeholder="Phone Number" required>
      </div>
      <div class="form-group"><i class="fas fa-envelope input-icon"></i>
        <input type="email" name="email_address" placeholder="Email Address" required>
      </div>

      <div class="form-group"><i class="fas fa-globe input-icon"></i>
        <input type="text" name="country_of_interest" placeholder="Country of Interest" required>
      </div>
      <div class="form-group"><i class="fas fa-map input-icon"></i>
        <input type="text" name="state_of_origin" placeholder="State of Origin" required>
      </div>
      <div class="form-group"><i class="fas fa-id-card input-icon"></i>
        <input type="text" name="nin" placeholder="National Identity Number" required>
      </div>
      <div class="form-group"><i class="fas fa-heart input-icon"></i>
        <select name="marital_status" required style="width:100%;padding:10px 35px;border-radius:8px;">
          <option value="">-- Select Marital Status --</option>
          <option value="Single">Single</option>
          <option value="Married">Married</option>
          <option value="Divorced">Divorced</option>
          <option value="Widowed">Widowed</option>
        </select>
      </div>
      <span style="font-size:14px;">Date Of Birth</span>
      <div class="form-group"><i class="fas fa-calendar input-icon"></i>
        <input type="date" name="dob" placeholder="Date of Birth" required>
      </div>

      <input type="hidden" name="my_sponsor" value="<?php echo empty($_GET['sponsor']) ? 'admin' : $_GET['sponsor']; ?>">

      <div class="form-group"><i class="fas fa-lock input-icon"></i>
        <input type="password" name="password" id="password" placeholder="Password" required>
        <i class="fas fa-eye toggle-password" onclick="togglePassword('password', this)"></i>
      </div>
      <div class="form-group"><i class="fas fa-lock input-icon"></i>
        <input type="password" name="confirm_password" id="confirm_password" placeholder="Confirm Password" required>
        <i class="fas fa-eye toggle-password" onclick="togglePassword('confirm_password', this)"></i>
      </div>

      <div class="form-check">
        <label><input type="checkbox"> Remember me</label>
      </div>

      <button type="submit" class="btn">Submit</button>

      <div class="form-note">
        <a href="https://rewardstream.com.ng/login.php">Already have an account? Log in</a>
      </div>
    </form>
  </div>

  <div class="page-loader" id="pageLoader">
    <div class="spinner"></div>
  </div>

  <script>
    function togglePassword(fieldId, icon) {
      const input = document.getElementById(fieldId);
      const isPassword = input.type === 'password';
      input.type = isPassword ? 'text' : 'password';
      icon.classList.toggle('fa-eye');
      icon.classList.toggle('fa-eye-slash');
    }

    function showLoader() {
      document.getElementById("pageLoader").style.display = "flex";
    }
  </script>
</body>
</html>
