<?php
session_start();
include("connect.php"); // your DB connection (must provide $con)

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}

/// ---------- CONFIG -----ctt key-----
$PAYSTACK_SECRET = 'sk_live_73d65edb013cfd44efd4410d648951bc8fafd176'; // <- REPLACE with your Paystack secret key

/// ---------- UTIL: call Paystack ----------
function paystack_call($endpoint, $post = null) {
    global $PAYSTACK_SECRET;
    $url = "https://api.paystack.co{$endpoint}";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    if ($post !== null) {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
    }
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer {$PAYSTACK_SECRET}",
        "Cache-Control: no-cache"
    ]);
    $resp = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($err) return ['status' => false, 'message' => $err];
    $json = json_decode($resp, true);
    return $json ?: ['status' => false, 'message' => 'Invalid JSON from Paystack'];
}

/// ---------- AJAX endpoints for frontend (bank list & resolve) ----------
if (isset($_GET['action']) && $_GET['action'] === 'bank_list') {
    header('Content-Type: application/json; charset=utf-8');
    $res = paystack_call('/bank'); // GET list of banks
    echo json_encode($res);
    exit;
}

if (isset($_GET['action']) && $_GET['action'] === 'resolve') {
    // POST: account_number, bank_code
    header('Content-Type: application/json; charset=utf-8');
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        echo json_encode(['status' => false, 'message' => 'Use POST']);
        exit;
    }
    $account_number = trim($_POST['account_number'] ?? '');
    $bank_code = trim($_POST['bank_code'] ?? '');
    if ($account_number === '' || $bank_code === '') {
        http_response_code(400);
        echo json_encode(['status' => false, 'message' => 'Missing account_number or bank_code']);
        exit;
    }
    $res = paystack_call("/bank/resolve?account_number=" . urlencode($account_number) . "&bank_code=" . urlencode($bank_code));
    echo json_encode($res);
    exit;
}

/// ---------- Normal page logic ----------
$phone_number = $_SESSION["phone_number"];
$message = "";
$message_type = "";

// Fetch user data
$user_query = mysqli_query($con, "SELECT * FROM members WHERE phone_number='" . mysqli_real_escape_string($con, $phone_number) . "' LIMIT 1");
$user = mysqli_fetch_assoc($user_query);
$earning_wallet = $user['earning_wallet'] ?? 0;

// Fetch pin data - just to check if PIN exists
$pin_query = mysqli_query($con, "SELECT * FROM withdraw_pins WHERE phone_number='" . mysqli_real_escape_string($con, $phone_number) . "' LIMIT 1");
$pin_data = mysqli_fetch_assoc($pin_query);
$withdraw_pin_exists = !empty($pin_data['pin'] ?? null);

// If PIN does not exist, redirect user to change_pin.php to set PIN first
if (!$withdraw_pin_exists) {
    header("Location: change_pin.php");
    exit;
}

// Handle withdrawal request (automatic via Paystack)
if (isset($_POST['request_withdrawal'])) {
    // expect POST fields: amount, bank_code, bank_name, account_number, account_name, withdraw_pin
    $amount = floatval($_POST['amount'] ?? 0);
    $bank_code = mysqli_real_escape_string($con, $_POST['bank_code'] ?? '');
    $bank_name = mysqli_real_escape_string($con, $_POST['bank_name'] ?? '');
    $account_number = mysqli_real_escape_string($con, $_POST['account_number'] ?? '');
    $account_name_client = mysqli_real_escape_string($con, $_POST['account_name'] ?? '');
    $entered_pin = $_POST['withdraw_pin'] ?? '';

    // Re-fetch the stored pin hash (in case it changed)
    $pin_check_query = mysqli_query($con, "SELECT pin FROM withdraw_pins WHERE phone_number = '" . mysqli_real_escape_string($con, $phone_number) . "' LIMIT 1");
    $pin_row = mysqli_fetch_assoc($pin_check_query);
    $stored_pin_hash = $pin_row['pin'] ?? '';

    if (!password_verify($entered_pin, $stored_pin_hash)) {
        $message = "Incorrect withdrawal PIN.";
        $message_type = "error";
    } elseif ($amount <= 0 || $amount > $earning_wallet) {
        $message = "Insufficient balance or invalid amount.";
        $message_type = "error";
    } elseif (empty($bank_code) || empty($account_number) || empty($account_name_client)) {
        $message = "Please complete bank details and verify account name.";
        $message_type = "error";
    } else {
        // 1) Server-side resolve (re-verify) to prevent client spoofing
        $resolve = paystack_call("/bank/resolve?account_number=" . urlencode($account_number) . "&bank_code=" . urlencode($bank_code));
        if (!($resolve['status'] ?? false)) {
            $message = "Could not verify account: " . ($resolve['message'] ?? 'Paystack error');
            $message_type = "error";
        } else {
            $resolved_name = $resolve['data']['account_name'] ?? '';
            // Loose case-insensitive compare
            if (strcasecmp(trim($resolved_name), trim($account_name_client)) !== 0) {
                $message = "Account name mismatch. Paystack shows: " . $resolved_name;
                $message_type = "error";
            } else {
                // 2) Create transfer recipient
                $recipient_payload = [
                    "type" => "nuban",
                    "name" => $resolved_name,
                    "account_number" => $account_number,
                    "bank_code" => $bank_code,
                    "currency" => "NGN"
                ];
                $recipient_res = paystack_call('/transferrecipient', $recipient_payload);
                if (!($recipient_res['status'] ?? false)) {
                    $message = "Failed to create transfer recipient: " . ($recipient_res['message'] ?? 'Unknown');
                    $message_type = "error";
                } else {
                    $recipient_code = $recipient_res['data']['recipient_code'];

                    // *** Calculate charge and net amount ***
                    $charge = $amount * 0.10; // 10% charge
                    $net_amount = $amount - $charge;

                    // 3) Initiate transfer - send net amount only
                    $transfer_payload = [
                        "source" => "balance",
                        "amount" => intval($net_amount * 100), // kobo after charge
                        "recipient" => $recipient_code,
                        "reason" => "Withdrawal from Q&A Earnings"
                    ];
                    $transfer_res = paystack_call('/transfer', $transfer_payload);

                    if (!($transfer_res['status'] ?? false)) {
                        $message = "Transfer failed: " . ($transfer_res['message'] ?? 'Unknown');
                        $message_type = "error";
                    } else {
                        // success: deduct wallet and log
                        $transaction_ref = $transfer_res['data']['reference'] ?? '';

                        // Insert into withdrawal_requests (keeps your original structure)
                        $stmt = $con->prepare("INSERT INTO withdrawal_requests (phone_number, bank_name, account_number, account_name, amount, status, request_date, transaction_ref) VALUES (?, ?, ?, ?, ?, 'completed', NOW(), ?)");
                        $stmt->bind_param("ssssds", $phone_number, $bank_name, $account_number, $resolved_name, $amount, $transaction_ref);
                        $ok1 = $stmt->execute();
                        $stmt->close();

                        // Deduct wallet full amount
                        $stmt2 = $con->prepare("UPDATE members SET earning_wallet = earning_wallet - ? WHERE phone_number = ?");
                        $stmt2->bind_param("ds", $amount, $phone_number);
                        $ok2 = $stmt2->execute();
                        $stmt2->close();

                        if ($ok1 && $ok2) {
                            $message = "Withdrawal successful. ₦" . number_format($amount, 2) . " deducted from wallet. ₦" . number_format($net_amount, 2) . " sent to your bank. Ref: {$transaction_ref}";
                            $message_type = "success";
                            // refresh local variable
                            $earning_wallet -= $amount;
                        } else {
                            // If DB error, record as pending maybe
                            $message = "Transfer succeeded but failed to update local records. Contact admin. Ref: {$transaction_ref}";
                            $message_type = "error";
                        }
                    }
                }
            }
        }
    }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Withdraw Funds</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
 /* Global box-sizing for consistent sizing */
*, *::before, *::after {
  box-sizing: border-box;
}

body {
    margin: 0;
    font-family: 'Segoe UI', sans-serif;
    background: #1c1c1c; /* very dark gray/black background */
    color: #ddd; /* light gray text for readability */
}

header, footer {
    background: linear-gradient(135deg, black, #805c00); /* rich gold gradient */
    color: white; /* light text for contrast */
    text-align: center;
    padding: 20px 15px;
    font-weight: 700;
    letter-spacing: 1px;
    text-shadow: 0 0 5px rgba(0,0,0,0.3);
    box-shadow: 0 3px 6px rgba(0,0,0,0.5);
}

.container {
    max-width: 600px;
    margin: 40px auto;
    padding: 30px 20px; /* reduced horizontal padding */
    background: #2e2e2e; /* dark gray container */
    border-radius: 12px;
    box-shadow: 0 0 20px rgba(191,160,74,0.6); /* soft golden glow */
    color: #eee;
    overflow-x: hidden; /* prevent horizontal scroll */
}

h2 {
    text-align: center;
    color: #d4af37; /* gold color */
    
    margin-bottom: 25px;
}

/* Amount options container with responsive grid */
.amount-options {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(100px, 1fr)); /* flexible columns */
    gap: 10px;
}

/* 3 columns explicitly on small screens */
@media (max-width: 600px) {
    .amount-options {
        grid-template-columns: repeat(3, 1fr);
    }
}

.amount-options button {
    width: 100%;
    max-width: 100%;
    padding: 10px 10px;
    background: linear-gradient(145deg, black, #a67c00);
    color: white;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    font-weight: 600;
    box-shadow: 0 3px 6px rgba(166,124,0,0.6);
    transition: background 0.3s ease, transform 0.2s ease;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}
.amount-options button:hover {
    background: linear-gradient(145deg, #a67c00, #d4af37);
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(166,124,0,0.8);
}

input, select {
    width: 100%;
    padding: 14px;
    margin: 10px 0 24px;
    border-radius: 8px;
    border: 1.5px solid #bfa04a;
    background: #444; /* dark input background */
    color: #eee;
    font-weight: 600;
    box-shadow: inset 0 0 6px rgba(191,160,74,0.4);
    transition: border-color 0.3s ease;
}

input:focus, select:focus {
    border-color: #d4af37;
    outline: none;
    box-shadow: 0 0 8px #d4af37;
    background: #555;
    color: #fff;
}

button.submit-btn {
    width: 100%;
    padding: 16px;
    background: linear-gradient(135deg, black, #805c00);
    color: white;
    border: none;
    font-size: 18px;
    border-radius: 8px;
    cursor: pointer;
    font-weight: 700;
    box-shadow: 0 5px 15px rgba(191,160,74,0.7);
    transition: background 0.3s ease, transform 0.2s ease;
}

button.submit-btn:hover {
    background: linear-gradient(135deg, #805c00, #bfa04a);
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(191,160,74,0.9);
}

#verify_icon {
    font-size: 20px;
    vertical-align: middle;
    color: #d4af37;
    text-shadow: 0 0 4px #bfa04a;
}

#chargesInfo {
    background: #333; /* dark gray box */
    border: 1px solid #bfa04a;
    padding: 14px 18px;
    margin-bottom: 24px;
    border-radius: 8px;
    font-size: 16px;
    color: #d4af37;
    box-shadow: 0 0 10px rgba(191,160,74,0.6);
    font-weight: 600;
}

</style>

</head>
<body>
<!---
<header>
    <h1><i class="fas fa-money-check-alt"></i> Withdrawal Request</h1>
</header>


<div style="text-align:left; margin: 20px 0;">
  <a href="dashboard.php" 
     style="
       color: #b8860b; 
       font-weight: 600; 
       text-decoration: none; 
       font-size: 16px; 
       border: 2px solid #b8860b; 
       padding: 8px 16px; 
       border-radius: 6px; 
       transition: background-color 0.3s, color 0.3s;
     "
     onmouseover="this.style.backgroundColor='#b8860b'; this.style.color='#1a1a1a';"
     onmouseout="this.style.backgroundColor='transparent'; this.style.color='#b8860b';"
  >
    &laquo; Back To Dashboard
  </a>
</div>------>

<header>
  <!--<div class="hamburger"><i class="fas fa-bars"></i></div>--->
  <strong>Automatic Payout System</strong>
</header>

<div class="mobile-menu" id="mobileMenu">
  <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
  <!--<a href="#"><i class="fas fa-wallet"></i> Wallet</a>
  <a href="#"><i class="fas fa-sign-out-alt"></i> Logout</a>--->
</div>

<div class="container">
     <h2><i class="fas fa-money-check-alt"></i> Withdraw Fund To Bank</h2>
     <p align="center"><strong>Earning Balance:</strong> ₦<?= number_format($earning_wallet, 2) ?></p>
     
     <br>
    <p><strong>Select Amount To Withdraw:</strong> </p>

    <form method="POST" id="withdrawForm">
        <div class="amount-options">
            <?php foreach ([100,200,500,1000,2000,5000,10000,20000,45000,50000,100000,250000,500000,1000000] as $amt): ?>
                <button type="button" onclick="setAmount(<?= $amt ?>);">₦<?= number_format($amt) ?></button>
            <?php endforeach; ?>
        </div>

        <input type="number" name="amount" id="amount" min="100" placeholder="Amount" readonly required>

        <div id="chargesInfo">
            <div><strong>Transaction Charges (10%):</strong> ₦<span id="chargesAmount">0.00</span></div>
            <div><strong>Amount to Receive:</strong> ₦<span id="netAmount">0.00</span></div>
        </div>

        <label>Select Bank</label>
        <select id="bank" required>
            <option value="">Loading banks...</option>
        </select>

        <input type="hidden" name="bank_code" id="bank_code_input">
        <input type="hidden" name="bank_name" id="bank_name_input">

        <label>Account Number</label>
        <div style="display:flex;gap:10px;align-items:center;">
            <input type="text" name="account_number" id="account_number" placeholder="Enter Account Number" required maxlength="10" style="flex:1;">
            <span id="verify_icon"></span>
        </div>

        <label>Account Name</label>
        <input type="text" name="account_name" id="account_name" placeholder="Account Name" readonly required>

        <label>Withdrawal PIN</label>
        <input type="password" name="withdraw_pin" placeholder="Enter Withdrawal PIN" required maxlength="4">

        <button class="submit-btn" type="submit" id="submitBtn" disabled name="request_withdrawal"><i class="fas fa-paper-plane"></i> Submit Request</button>
    </form>

    <?php if (!empty($message)): ?>
        <script>
            document.addEventListener("DOMContentLoaded", function(){
                Swal.fire({
                    icon: '<?= $message_type === "success" ? "success" : "error" ?>',
                    title: '<?= $message_type === "success" ? "Success" : "Error" ?>',
                    html: '<?= nl2br(htmlspecialchars($message, ENT_QUOTES)) ?>'
                }).then(() => {
                    <?php if ($message_type === 'success'): ?>
                        window.location.href = 'withdrawal_history.php';
                    <?php endif; ?>
                });
            });
        </script>
    <?php endif; ?>

    <p style="margin-top: 20px; text-align:center;">
        Need to set or reset your withdrawal PIN? <a href="change_pin.php" style="color:#004080; font-weight:bold;">Click here</a>.
    </p>
</div>

<script>
const proxy = '<?= basename(__FILE__) ?>'; // this same file handles AJAX endpoints
const bankSelect = document.getElementById('bank');
const bankCodeInput = document.getElementById('bank_code_input');
const bankNameInput = document.getElementById('bank_name_input');
const accountInput = document.getElementById('account_number');
const accountName = document.getElementById('account_name');
const verifyIcon = document.getElementById('verify_icon');
const submitBtn = document.getElementById('submitBtn');
const amountInput = document.getElementById('amount');

function setAmount(val) {
    amountInput.value = val;
    updateCharges();
}

function updateCharges() {
    let amount = parseFloat(amountInput.value) || 0;
    if (amount < 100) {
        document.getElementById('chargesAmount').textContent = '0.00';
        document.getElementById('netAmount').textContent = '0.00';
        submitBtn.disabled = true;
        return;
    }
    let charge = amount * 0.10;
    let payout = amount - charge;
    document.getElementById('chargesAmount').textContent = charge.toFixed(2);
    document.getElementById('netAmount').textContent = payout.toFixed(2);
    submitBtn.disabled = !(verified && amount >= 100);
}

document.querySelectorAll('.amount-options button').forEach(btn => {
    btn.addEventListener('click', function() {
        let val = parseFloat(this.textContent.replace(/[^0-9]/g, ''));
        setAmount(val);
    });
});

amountInput.addEventListener('input', updateCharges);

// Load bank list from server (server calls Paystack with secret key)
fetch(proxy + '?action=bank_list')
.then(r => r.json())
.then(data => {
    bankSelect.innerHTML = '<option value="">-- Select Bank --</option>';
    if (data.status && Array.isArray(data.data)) {
        data.data.forEach(b => {
            const opt = document.createElement('option');
            opt.value = b.code + '||' + b.name;
            opt.textContent = b.name;
            bankSelect.appendChild(opt);
        });
    } else {
        bankSelect.innerHTML = '<option value="">Unable to load banks</option>';
    }
})
.catch(() => {
    bankSelect.innerHTML = '<option value="">Error loading banks</option>';
});

let verified = false;
function setVerified(ok, name='') {
    verified = ok;
    if (ok) {
        verifyIcon.innerHTML = '✅';
        verifyIcon.style.color = 'green';
        accountName.value = name;
        updateCharges();
    } else {
        verifyIcon.innerHTML = '❌';
        verifyIcon.style.color = 'red';
        accountName.value = '';
        submitBtn.disabled = true;
    }
}

function clearVerify() {
    verified = false;
    verifyIcon.innerHTML = '';
    accountName.value = '';
    submitBtn.disabled = true;
    updateCharges();
}

function resolveAccount() {
    const sel = bankSelect.value;
    if (!sel) { clearVerify(); return; }
    const [bank_code, bank_name] = sel.split('||');
    const acc = accountInput.value.replace(/\D/g,'').trim();
    if (acc.length !== 10) { clearVerify(); return; }

    verifyIcon.innerHTML = '⏳';
    verifyIcon.style.color = 'blue';
    accountName.value = '';

    const form = new FormData();
    form.append('account_number', acc);
    form.append('bank_code', bank_code);

    fetch(proxy + '?action=resolve', {
        method: 'POST',
        body: form
    })
    .then(r => r.json())
    .then(data => {
        if (data.status && data.data && data.data.account_name) {
            setVerified(true, data.data.account_name);
            bankCodeInput.value = bank_code;
            bankNameInput.value = bank_name;
        } else {
            setVerified(false);
        }
    })
    .catch(() => {
        verifyIcon.innerHTML = '⚠️';
        verifyIcon.style.color = 'orange';
        accountName.value = 'Error verifying';
        submitBtn.disabled = true;
        verified = false;
    });
}

bankSelect.addEventListener('change', resolveAccount);
accountInput.addEventListener('input', () => {
    // delay verify until 10 digits entered
    if (accountInput.value.replace(/\D/g,'').length === 10) {
        resolveAccount();
    } else {
        clearVerify();
    }
});

</script>

<footer>
    <p>&copy; <?= date('Y') ?> <?= htmlspecialchars($_SERVER['HTTP_HOST']) ?>. All rights reserved.</p>
</footer>
</body>
</html>
