<?php
// payment_callback.php
session_start();
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}

include('connect.php');
include('env-helper.php');
//require_once __DIR__ . '/env-helper.php';

/**
 * Load an environment variable from .env file
 */


$reference = isset($_GET['reference']) ? trim($_GET['reference']) : '';
$status_text = 'pending';

if ($reference) {
    $paystack_secret = getEnvValue('PAYSTACK_DEPOSIT_SECRET');
    if ($paystack_secret) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . rawurlencode($reference),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                "accept: application/json",
                "authorization: Bearer {$paystack_secret}",
                "cache-control: no-cache"
            ],
            CURLOPT_TIMEOUT => 60
        ]);
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if (!$err && $response) {
            $tranx = json_decode($response, true);
            if (!empty($tranx['status']) && isset($tranx['data']['status'])) {
                $status_text = $tranx['data']['status']; // success, failed, or pending
            }
        }
    }
}
?>
<script>
    const s = <?php echo json_encode($status_text); ?>;
    const url = new URL("dashboard.php", window.location.origin);
    url.searchParams.set("pay_status", s);
    window.location.replace(url.toString());
</script>
