<?php
session_start();
include('connect.php');

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}

// Fetch all packages
$packages = [];
$query = mysqli_query($con, "SELECT * FROM packages ORDER BY level ASC");
while ($row = mysqli_fetch_assoc($query)) {
    $packages[] = $row;
}
?>

<?php include('header.php')?>

 

<!--
<div class="container">
  <h2><i class="fas fa-boxes-stacked"></i> Available Packages</h2>
  <div class="packages-grid">
    <?php foreach ($packages as $pkg): ?>
      <div class="package-card">
        <!-- Package icon -->
        <!---<div class="package-icon"><i class="fas fa-gem"></i></div>
        
        <div class="package-name"><?= htmlspecialchars($pkg['package_name']) ?></div>
        
        <div class="package-info"><strong><i class="fas fa-wallet"></i> Activation Fee:</strong> ₦<?= number_format($pkg['activation_amount']) ?></div>
        <div class="package-info"><strong><i class="fas fa-tasks"></i> Task Limit:</strong> <?= $pkg['task_limit'] ?> / day</div>
        <div class="package-info"><strong><i class="fas fa-coins"></i> Earn per Task:</strong> ₦<?= number_format($pkg['task_rate']) ?></div>
        <div class="package-info"><strong><i class="fas fa-calendar-day"></i> Daily Earning:</strong> ₦<?= number_format($pkg['task_limit'] * $pkg['task_rate']) ?></div>
        
        <a href="activate_package.php?id=<?= $pkg['id'] ?>">
          <button class="activate-btn"><i class="fas fa-rocket"></i> Activate Package</button>
        </a>
      </div>
    <?php endforeach; ?>
  </div>
</div>
--------------->



 <!-- package section start -->
    <section class="pt-120 pb-120">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-6 text-center">
            <div class="section-header">
              <h2 class="section-title"><span class="font-weight-normal">Earning</span> <b class="base--color">Packages</b></h2>
              <p>Pick the right plan for your earning goals. Each package comes with a set number of daily questions and earnings per answer.</p>
            </div>
          </div>
        </div><!-- row end -->
        <div class="row justify-content-center mb-none-30">
        
        <?php foreach ($packages as $pkg): ?>
        
          <div class="col-xl-3 col-lg-4 col-md-6 mb-30">
            <div class="package-card text-center bg_img" data-background="assets/images/bg/bg-4.png">
                
              <h4 class="package-card__title base--color mb-2" style="color: #fff; background: linear-gradient(90deg, gold, black, gray); padding:8px; border-radius:6px;"><?= htmlspecialchars($pkg['package_name']) ?></h4>
              
              <ul class="package-card__features mt-4">
                <li>Question Limit:</strong> <?= $pkg['task_limit'] ?> / day</li>
                <li>Earn per Answer:</strong> ₦<?= number_format($pkg['task_rate']) ?></li>
                <li>Daily Earning:</strong> ₦<?= number_format($pkg['task_limit'] * $pkg['task_rate']) ?></li>
                <li>Duration: <?= $pkg['duration'] ?>-Days</li>
              </ul>
              <div class="package-card__range mt-5 base--color">₦<?= number_format($pkg['activation_amount']) ?></div>
              <a href="activate_package.php?id=<?= $pkg['id'] ?>" class="cmn-btn btn-md mt-4" style="color: #fff; background: linear-gradient(90deg, gold, black, gray); padding:8px; border-radius:6px;">Activate Package</a>
            </div><!-- package-card end -->
          </div>
         <?php endforeach; ?>
          
        </div><!-- row end -->
      </div>
    </section>
    <!-- package section end  -->






<script>
  function toggleMenu() {
    document.getElementById("navLinks").classList.toggle("active");
  }

  // Preloader
  window.addEventListener("load", () => {
    document.getElementById("preloader").style.display = "none";
  });
</script>


<?php include('footer.php')?>