<?php
// Initialize the session
session_start();
 
// Check if the user is already logged in, if yes then redirect him to welcome page
/*
if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true){
    header("location: index.php");
    exit;
}
*/
 
 
 
 include('config.php');

//////////////forgot password buton////////////////////////
if(isset($_POST['forgot_password'])){?>
<script>window.top.location='forgot_password.php'</script>
<?php
} 
/////////////////////////


// Define variables and initialize with empty values
$phone_number = $password = "";
$phone_number_err = $password_err = "";
 
// Processing form data when form is submitted
if(isset($_POST['submit'])){
 
    // Check if phone_number is empty
    if(empty(trim($_POST["phone_number"]))){
        $phone_number_err = "Please enter phone number.";
    } else{
        $phone_number = trim($_POST["phone_number"]);
    }
    
    // Check if password is empty
    if(empty(trim($_POST["password"]))){
        $password_err = "Please enter your password.";
    } else{
        $password = trim($_POST["password"]);
    }
    
    // Validate credentials
    if(empty($phone_number_err) && empty($password_err)){
        // Prepare a select statement
        $sql = "SELECT id, phone_number, password FROM members WHERE phone_number = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_phone_number );
            
            // Set parameters
            $param_phone_number = $phone_number;
			
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                // Store result
                mysqli_stmt_store_result($stmt);
                
                // Check if phone_number exists, if yes then verify password
                if(mysqli_stmt_num_rows($stmt) == 1){                    
                    // Bind result variables
                    mysqli_stmt_bind_result($stmt, $id, $phone_number,  $hashed_password);
                    if(mysqli_stmt_fetch($stmt)){
                        if(password_verify($password, $hashed_password)){
                            // Password is correct, so start a new session
                            session_start();
                            
                            
                            ////update pop message on dashboard to show each time user login 
                            mysqli_query($link, "UPDATE members SET popup_shown = 0 WHERE phone_number = '$phone_number'");
/////////////////////////////////////////////////////////////////

                            // Store data in session variables
                            $_SESSION["loggedin"] = true;
                            $_SESSION["id"] = $id;
                            $_SESSION["phone_number"] = $phone_number;                            
                            
                            // Redirect user to welcome page
                            ?>
                            <script>window.top.location='dashboard.php'</script>
                            <?php
                           
                        } else{
                            // Display an error message if password is not valid
                            $password_err = "The password you entered was not valid.";
                        }
                    }
                } else{
                    // Display an error message if phone_number doesn't exist
                    $phone_number_err = "No account found with that phone number.";
                }
            } else{
                echo "Oops! Something went wrong. Please try again later.";
            }
        }
        
        // Close statement
        mysqli_stmt_close($stmt);
    }
    
    // Close connection
    mysqli_close($link);
}
?>


<?php include('header.php')?>


<!-- Preloader -->
<div class="preloader" id="preloader">
  <div class="spinner"></div>
  <h4> Login</h4>
</div>






<!-- account section start -->
<div class="account-section bg_img" data-background="assets/images/bg/bg-5.jpg">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-xl-5 col-lg-7">
        <div class="account-card">
          <div class="account-card__header bg_img overlay--one" data-background="assets/images/bg/bg-6.jpg">
              
              <div align="center">
              <img src="images/logoc.png" alt="Logo" style="width:100px;height:auto;">
              </div>
              
            <h2 class="section-title">Welcome to <span class="base--color">CashFunz</span></h2>
            <p>Answer questions, earn money, and get paid instantly in Naira. Your knowledge is your income!</p>
          </div>
          <div class="account-card__body">
                <!-- Title -->
                    <h4 class="card-title text-center mb-3" style="color: #fff; background: linear-gradient(90deg, gold, black, gray); padding:8px; border-radius:6px;">
                        User Login
                    </h4>
            

            <!-- Error messages -->
            <div class="error-message text-center text-danger">
              <?php echo @$password_err; ?>
              <?php echo @$phone_number_err; ?>
            </div>

            <!-- Login Form -->
            <form class="mt-4" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" onsubmit="showSubmitPreloader()">
              
              <div class="form-group">
                <label for="phone_number">Phone Number</label>
                <input type="text" name="phone_number" id="phone_number" class="form-control" placeholder="Enter phone number" required>
              </div>

              <div class="form-group">
                <label for="password">Password</label>
                <div class="position-relative">
                  <input type="password" name="password" id="password" class="form-control" placeholder="Enter password" required>
                  <i class="fas fa-eye toggle-password" onclick="togglePassword('password', this)" style="position:absolute; top:50%; right:10px; transform:translateY(-50%); cursor:pointer;"></i>
                </div>
              </div>

              <div class="form-row">
                <div class="col-sm-6">
                  <div class="form-group form-check">
                    <input type="checkbox" class="form-check-input" id="rememberMe">
                    <label class="form-check-label" for="rememberMe">Remember me</label>
                  </div>
                </div>
                <div class="col-sm-6 text-sm-right">
                  <a href="forgot_password.php" class="f-size-14 base--color">Forgot Password?</a>
                </div>
              </div>

              <div class="mt-3">
                <button type="submit" name="submit" class="cmn-btn">Login Now</button>
              </div>

              <div class="text-center mt-3">
                <p class="f-size-14">Don't have an account? <a href="register.php" class="base--color">Sign Up</a></p>
              </div>

            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- account section end -->





<script>
  /// Page load preloader
  window.addEventListener("load", function() {
    document.getElementById("preloader").style.display = "none";
  });

  // Show preloader on form submit
  function showSubmitPreloader() {
    document.getElementById("preloader").style.display = "flex";
  }

  // Toggle password visibility
  function togglePassword(fieldId, icon) {
    const input = document.getElementById(fieldId);
    const isPassword = input.type === 'password';
    input.type = isPassword ? 'text' : 'password';
    icon.classList.toggle('fa-eye');
    icon.classList.toggle('fa-eye-slash');
  }
</script>


<?php include('footer.php')?>
