<?php
include('connect.php');

// Fetch all packages
$packages = [];
$query = mysqli_query($con, "SELECT * FROM packages ORDER BY level ASC");
while ($row = mysqli_fetch_assoc($query)) {
    $packages[] = $row;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>CashFunz Investment</title>
  <link rel="icon" type="image/png" href="images/logoc.png" sizes="16x16">
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/all.min.css">
  <link rel="stylesheet" href="css/line-awesome.min.css">
  <link rel="stylesheet" href="css/animate.min.css">
  <link rel="stylesheet" href="css/slick.css">
  <link rel="stylesheet" href="css/dots.css">
  <link rel="stylesheet" href="css/main.css">
</head>
<body>
  <div class="preloader">
    <div class="preloader-container">
      <span class="animated-preloader"></span>
    </div>
  </div>

  <div class="scroll-to-top">
    <span class="scroll-icon">
      <i class="fa fa-rocket" aria-hidden="true"></i>
    </span>
  </div>

  <div class="full-wh">
    <div class="bg-animation">
      <div id="stars"></div>
      <div id="stars2"></div>
      <div id="stars3"></div>
      <div id="stars4"></div>
    </div>
  </div>

  <div class="page-wrapper">
    <header class="header">
      <div class="header__bottom">
        <div class="container">
          <nav class="navbar navbar-expand-xl p-0 align-items-center">
            <a class="site-logo site-title" href="index.php"><img src="images/logoc.png" alt="CashFunz Logo"></a>
            <ul class="account-menu mobile-acc-menu">
              <li class="icon">
                <a href="login.php"><i class="las la-user"></i></a>
              </li>
            </ul>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent">
              <span class="menu-toggle"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
              <ul class="navbar-nav main-menu m-auto">
                <li><a href="index.php">Home</a></li>
                <li><a href="register.php">Register</a></li>
                <li><a href="login.php">Login</a></li>
                <li><a href="dashboard.php">Dashboard</a></li>
              </ul>
            </div>
          </nav>
        </div>
      </div>
    </header>

    <!-- Hero Section -->
    <section class="hero bg_img" data-background="images/gold.webp">
      <div class="container">
        <div class="row">
          <div class="col-xl-5 col-lg-8">
            <div class="hero__content">
              <h2 class="hero__title">
                <span class="text-white font-weight-normal">Earn Money Online by Answering Questions</span> 
                <b class="base--color">with CashFunz Investment</b>
              </h2>
              <p class="text-white f-size-18 mt-3">
                Join Nigeria’s fast-growing “Answer and Earn” platform. Simply choose a package, answer daily questions, and get paid directly in Naira. No complicated investments, no waiting — just simple, consistent daily income.
              </p>
              <a href="register.php" class="cmn-btn text-uppercase font-weight-600 mt-4">Sign Up Now</a>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Stats Section -->
    <div class="cureency-section">
      <div class="container">
        <div class="row mb-none-30">
          <div class="col-lg-3 col-sm-6 cureency-item mb-30">
            <div class="cureency-card text-center">
              <h6 class="cureency-card__title text-white">Active Users</h6>
              <span class="cureency-card__amount h-font-family font-weight-600 base--color">6,150+</span>
            </div>
          </div>
          <div class="col-lg-3 col-sm-6 cureency-item mb-30">
            <div class="cureency-card text-center">
              <h6 class="cureency-card__title text-white">Daily Participants</h6>
              <span class="cureency-card__amount h-font-family font-weight-600 base--color">10,000+</span>
            </div>
          </div>
          <div class="col-lg-3 col-sm-6 cureency-item mb-30">
            <div class="cureency-card text-center">
              <h6 class="cureency-card__title text-white">Questions Available</h6>
              <span class="cureency-card__amount h-font-family font-weight-600 base--color">1,500+</span>
            </div>
          </div>
          <div class="col-lg-3 col-sm-6 cureency-item mb-30">
            <div class="cureency-card text-center">
              <h6 class="cureency-card__title text-white">Total Payouts</h6>
              <span class="cureency-card__amount h-font-family font-weight-600 base--color">₦12M+</span>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- About Section -->
    <section class="about-section pt-120 pb-120 bg_img" data-background="">
      <div class="container">
        <div class="row">
          <div class="col-lg-6 offset-lg-6">
            <div class="about-content">
              <h2 class="section-title mb-3"><span class="font-weight-normal">About</span> <b class="base--color">CashFunz</b></h2>
              <p>
                CashFunz Investment is a digital earning platform that rewards you in Naira for answering simple daily questions. We designed our system for Nigerians who want a reliable, flexible, and transparent way to make extra income online.
              </p>
              <p class="mt-4">
                Our mission is to give everyone — students, workers, and business owners — a way to turn knowledge and participation into steady cash flow. With our packages, you choose how much you want to earn daily, answer the required number of questions, and get paid instantly to your wallet.
              </p>
              <a href="about.php" class="cmn-btn mt-4">Learn More</a>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Packages -->
    <section class="pt-120 pb-120">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-6 text-center">
            <div class="section-header">
              <h2 class="section-title"><span class="font-weight-normal">Earning</span> <b class="base--color">Packages</b></h2>
              <p>Pick the right plan for your earning goals. Each package comes with a set number of daily questions and earnings per answer.</p>
            </div>
          </div>
        </div>
        <div class="row justify-content-center mb-none-30">
          <?php foreach ($packages as $pkg): ?>
          <div class="col-xl-3 col-lg-4 col-md-6 mb-30">
            <div class="package-card text-center bg_img" data-background="assets/images/bg/bg-4.png">
              <h4 class="package-card__title base--color mb-2"><?= htmlspecialchars($pkg['package_name']) ?></h4>
              <ul class="package-card__features mt-4">
                <li>Questions per Day: <?= $pkg['task_limit'] ?></li>
                <li>Earn per Answer: ₦<?= number_format($pkg['task_rate']) ?></li>
                <li>Daily Potential: ₦<?= number_format($pkg['task_limit'] * $pkg['task_rate']) ?></li>
                <li>Duration: <?= $pkg['duration'] ?>-Days</li>
              </ul>
              <div class="package-card__range mt-5 base--color">₦<?= number_format($pkg['activation_amount']) ?></div>
              <a href="activate_package.php?id=<?= $pkg['id'] ?>" class="cmn-btn btn-md mt-4">Activate Package</a>
            </div>
          </div>
          <?php endforeach; ?>
        </div>
      </div>
    </section>

    <!-- package section end  -->


<!-- choose us section start -->
<section class="pt-120 pb-120 overlay--radial bg_img" data-background="assets/images/bg/bg-3.jpg">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-6 text-center">
        <div class="section-header">
          <h2 class="section-title"><span class="font-weight-normal">Why Choose</span> <b class="base--color">Our Platform</b></h2>
          <p>We make it easy for you to earn daily by simply activating a package, answering simple questions, and getting paid instantly — all from the comfort of your device.</p>
        </div>
      </div>
    </div><!-- row end -->

    <div class="row justify-content-center mb-none-30">
      
      <div class="col-xl-4 col-md-6 mb-30">
        <div class="choose-card border-radius--5">
          <div class="choose-card__header mb-3">
            <div class="choose-card__icon">
              <i class="las la-bolt"></i>
            </div>
            <h4 class="choose-card__title base--color">Instant Activation</h4>
          </div>
          <p>Activate your package in seconds and start earning immediately — no long waiting times.</p>
        </div>
      </div>

      <div class="col-xl-4 col-md-6 mb-30">
        <div class="choose-card border-radius--5">
          <div class="choose-card__header mb-3">
            <div class="choose-card__icon">
              <i class="las la-question-circle"></i>
            </div>
            <h4 class="choose-card__title base--color">Answer & Earn</h4>
          </div>
          <p>Get rewarded daily just for answering quick and fun questions — it’s simple and engaging.</p>
        </div>
      </div>

      <div class="col-xl-4 col-md-6 mb-30">
        <div class="choose-card border-radius--5">
          <div class="choose-card__header mb-3">
            <div class="choose-card__icon">
              <i class="las la-wallet"></i>
            </div>
            <h4 class="choose-card__title base--color">Daily Payouts</h4>
          </div>
          <p>Withdraw your earnings every day with no delays — fast, secure, and hassle-free.</p>
        </div>
      </div>

      <div class="col-xl-4 col-md-6 mb-30">
        <div class="choose-card border-radius--5">
          <div class="choose-card__header mb-3">
            <div class="choose-card__icon">
              <i class="las la-user-friends"></i>
            </div>
            <h4 class="choose-card__title base--color">Earn More With Referrals</h4>
          </div>
          <p>Invite friends and earn extra bonuses every time they activate their package and participate.</p>
        </div>
      </div>

      <div class="col-xl-4 col-md-6 mb-30">
        <div class="choose-card border-radius--5">
          <div class="choose-card__header mb-3">
            <div class="choose-card__icon">
              <i class="las la-headset"></i>
            </div>
            <h4 class="choose-card__title base--color">24/7 Support</h4>
          </div>
          <p>Our friendly support team is always available to help you get the best from your experience.</p>
        </div>
      </div>

      <div class="col-xl-4 col-md-6 mb-30">
        <div class="choose-card border-radius--5">
          <div class="choose-card__header mb-3">
            <div class="choose-card__icon">
              <i class="las la-shield-alt"></i>
            </div>
            <h4 class="choose-card__title base--color">Safe & Secure</h4>
          </div>
          <p>Your account and funds are protected with advanced security measures at all times.</p>
        </div>
      </div>

    </div>
  </div>
</section>
<!-- choose us section end -->



<!-- Profit Calculator Section -->
<section id="profit-calculator" class="py-5" style="background: linear-gradient(135deg, #1a1a1a, #000000); color: #FFD700;">
    <div class="container">
        <h2 class="text-center mb-4">Profit Calculator</h2>
        <p class="text-center mb-4">Estimate your earnings before you start!</p>
        <div class="row justify-content-center">
            <div class="col-md-6">
                <form id="calculator-form" class="p-4 rounded" style="background: rgba(255, 255, 255, 0.05);">
                    <div class="form-group mb-3">
                        <label for="questions">Questions per day</label>
                        <input type="number" id="questions" class="form-control" placeholder="e.g. 20">
                    </div>
                    <div class="form-group mb-3">
                        <label for="reward">Average reward per question (₦)</label>
                        <input type="number" id="reward" class="form-control" placeholder="e.g. 50">
                    </div>
                    <div class="form-group mb-3">
                        <label for="days">Days per month</label>
                        <input type="number" id="days" class="form-control" placeholder="e.g. 30">
                    </div>
                    <button type="button" onclick="calculateProfit()" class="btn btn-warning w-100">Calculate</button>
                </form>
                <div id="result" class="mt-3 text-center" style="font-size: 1.2rem; font-weight: bold;"></div>
            </div>
        </div>
    </div>
</section>

<script>
function calculateProfit() {
    let questions = parseFloat(document.getElementById('questions').value) || 0;
    let reward = parseFloat(document.getElementById('reward').value) || 0;
    let days = parseFloat(document.getElementById('days').value) || 0;
    let total = questions * reward * days;
    document.getElementById('result').innerHTML = "Your Estimated Monthly Earnings: ₦" + total.toLocaleString();
}
</script>

<!-- How It Works Section -->
<section id="how-it-works" class="py-5" style="background: linear-gradient(135deg, #000000, #2c2c2c); color: #FFD700;">
    <div class="container">
        <h2 class="text-center mb-4">How It Works</h2>
        <div class="row text-center">
            <div class="col-md-3 mb-4">
                <h5>1️⃣ Create Your Free Account</h5>
                <p>Sign up and log in to get started.</p>
            </div>
            <div class="col-md-3 mb-4">
                <h5>2️⃣ Choose a Question</h5>
                <p>Select from topics you know best.</p>
            </div>
            <div class="col-md-3 mb-4">
                <h5>3️⃣ Submit Your Answer</h5>
                <p>Provide accurate and helpful responses.</p>
            </div>
            <div class="col-md-3 mb-4">
                <h5>4️⃣ Get Paid in Naira</h5>
                <p>Your wallet updates instantly. Withdraw anytime.</p>
            </div>
        </div>
    </div>
</section>


<!-- cta section start -->
<section class="pb-120">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-xl-8">
        <div class="cta-wrapper bg_img border-radius--10 text-center" data-background="assets/images/bg/bg-8.jpg">
          <h2 class="title mb-3">Get Started Today With Us</h2>
          <p>This is a Revolutionary Knowledge-to-Cash Platform! Answer questions, earn instantly, and withdraw to your bank. No risks, just your smarts and consistency.</p>
          <a href="register.php" class="cmn-btn mt-4">Join Us</a>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- cta section end -->



    <!-- blog section start -->
<section class="pt-120 pb-120 border-top-1">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-6 text-center">
        <div class="section-header">
          <h2 class="section-title"><span class="font-weight-normal">Latest</span> <b class="base--color">Tips & Updates</b></h2>
          <p>Stay informed with the newest ways to earn more by answering questions, improving your accuracy, and boosting your rewards on CashFunz.</p>
        </div>
      </div>
    </div><!-- row end -->

    <div class="row justify-content-center mb-none-30">
      <div class="col-lg-4 col-md-6 mb-30">
        <div class="blog-card">
          <div class="blog-card__thumb">
            <img src="images/blog-earn-more.jpg" alt="image">
          </div>
          <div class="blog-card__content">
            <h4 class="blog-card__title mb-3"><a href="#0">5 Proven Ways to Earn More per Question</a></h4>
            <ul class="blog-card__meta d-flex flex-wrap mb-4">
              <li><i class="las la-user"></i><a href="#0">CashFunz Team</a></li>
              <li><i class="las la-calendar"></i><a href="#0">5 Aug, 2025</a></li>
            </ul>
            <p>Discover how top earners on CashFunz maximize their daily income by focusing on accuracy, speed, and choosing the right categories.</p>
            <a href="#0" class="cmn-btn btn-md mt-4">Read More</a>
          </div>
        </div>
      </div>

      <div class="col-lg-4 col-md-6 mb-30">
        <div class="blog-card">
          <div class="blog-card__thumb">
            <img src="images/blog-withdraw.jpg" alt="image">
          </div>
          <div class="blog-card__content">
            <h4 class="blog-card__title mb-3"><a href="#0">How Withdrawals Work – Step-by-Step Guide</a></h4>
            <ul class="blog-card__meta d-flex flex-wrap mb-4">
              <li><i class="las la-user"></i><a href="#0">CashFunz Support</a></li>
              <li><i class="las la-calendar"></i><a href="#0">29 Jul, 2025</a></li>
            </ul>
            <p>Learn exactly how to move your earnings from your CashFunz wallet to your bank account—fast, secure, and hassle-free.</p>
            <a href="#0" class="cmn-btn btn-md mt-4">Read More</a>
          </div>
        </div>
      </div>

      <div class="col-lg-4 col-md-6 mb-30">
        <div class="blog-card">
          <div class="blog-card__thumb">
            <img src="images/blog-topics.jpg" alt="image">
          </div>
          <div class="blog-card__content">
            <h4 class="blog-card__title mb-3"><a href="#0">Top 10 High-Paying Question Categories</a></h4>
            <ul class="blog-card__meta d-flex flex-wrap mb-4">
              <li><i class="las la-user"></i><a href="#0">CashFunz Insights</a></li>
              <li><i class="las la-calendar"></i><a href="#0">21 Jul, 2025</a></li>
            </ul>
            <p>Find out which topics give you the biggest rewards for your time so you can work smarter, not harder.</p>
            <a href="#0" class="cmn-btn btn-md mt-4">Read More</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- blog section end -->


    <!-- subscribe section start -->
    <section class="pb-120">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-lg-10">
            <div class="subscribe-wrapper bg_img" data-background="assets/images/bg/bg-5.jpg">
              <div class="row align-items-center">
                <div class="col-lg-5">
                  <h2 class="title">Subscribe Our Newsletter</h2>
                </div>
                <div class="col-lg-7 mt-lg-0 mt-4">
                  <form class="subscribe-form">
                    <input type="email" class="form-control" placeholder="Email Address">
                    <button class="subscribe-btn"><i class="las la-envelope"></i></button>
                  </form>
                </div>
              </div>
            </div><!-- subscribe-wrapper end -->
          </div>
        </div>
      </div>
    </section>
    <!-- subscribe section end -->


    <!-- footer section start -->
<footer class="footer bg_img" data-background="images/logoc.png">
  <div class="footer__top">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-12 text-center">
          <a href="#0" class="footer-logo"><img src="images/logoc.png" alt="image"></a>
          <ul class="footer-short-menu d-flex flex-wrap justify-content-center mt-4">
            <li><a href="#0">Home</a></li>
            <li><a href="#0">Privacy & Policy</a></li>
            <li><a href="#0">Terms & Conditions</a></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
  <div class="footer__bottom">
    <div class="container">
      <div class="row">
        <div class="col-md-6 text-md-left text-center">
          <p>© 2025 <a href="index.html" class="base--color">CashFunz</a>. All rights reserved</p>
        </div>
        <div class="col-md-6">
          <ul class="social-link-list d-flex flex-wrap justify-content-md-end justify-content-center">
            <li><a href="#0" data-toggle="tooltip" data-placement="top" title="facebook"><i class="lab la-facebook-f"></i></a></li>
            <li><a href="#0" data-toggle="tooltip" data-placement="top" title="twitter"><i class="lab la-twitter"></i></a></li>
            <li><a href="#0" data-toggle="tooltip" data-placement="top" title="pinterest"><i class="lab la-pinterest-p"></i></a></li>
            <li><a href="#0" data-toggle="tooltip" data-placement="top" title="pinterest"><i class="lab la-pinterest-in"></i></a></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</footer>
<!-- footer section end -->
  </div> <!-- page-wrapper end -->
    <!-- jQuery library -->
  <script src="js/jquery-3.5.1.min.js"></script>
  <!-- bootstrap js -->
  <script src="js/bootstrap.bundle.min.js"></script>
  <!-- slick slider js -->
  <script src="js/slick.min.js"></script>
  <script src="js/wow.min.js"></script>
  <script src="js/contact.js"></script>
  <!-- dashboard custom js -->
  <script src="js/app.js"></script>
  
 </body></html>