<?php
include 'connect.php';

$limit = 4;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $limit;

$icons = ['fa-rocket', 'fa-gem', 'fa-coins', 'fa-star', 'fa-crown', 'fa-fire'];
$colors = ['#007bff', '#28a745', '#17a2b8', '#ffc107', '#e83e8c', '#6f42c1'];

$total_result = mysqli_query($con, "SELECT COUNT(*) AS total FROM packages");
$total_row = mysqli_fetch_assoc($total_result);
$total_packages = $total_row['total'];
$total_pages = ceil($total_packages / $limit);

$package_query = "SELECT * FROM packages ORDER BY id ASC LIMIT $start, $limit";
$package_result = mysqli_query($con, $package_query);

$html = '';
$index = 0;
while ($pkg = mysqli_fetch_assoc($package_result)) {
    $daily_earning = $pkg['task_rate'] * $pkg['task_limit'];
    $icon = $icons[$index % count($icons)];
    $color = $colors[$index % count($colors)];
    $html .= "
      <div class='package-card'>
        <i class='fas $icon' style='color:$color; font-size: 24px;'></i>
        <h3 style='color:$color;'>" . htmlspecialchars($pkg['package_name']) . "</h3>
        <p>Activation Fee: ₦" . number_format($pkg['activation_amount']) . "</p>
        <p>Daily Task Limit: {$pkg['task_limit']}</p>
        <p>Daily Earning: ₦" . number_format($daily_earning) . "</p>
        <button>Activate Package</button>
      </div>";
    $index++;
}

// Build pagination buttons
$pagination = '';
if ($total_pages > 1) {
    if ($page > 1) {
        $pagination .= '<a href="#" data-page="' . ($page - 1) . '" style="margin-right:8px; color:#007bff;"><i class="fas fa-angle-left"></i> Prev</a>';
    }

    for ($i = 1; $i <= $total_pages; $i++) {
        $pagination .= '<a href="#" data-page="' . $i . '" style="margin:0 6px; padding:6px 10px; border-radius:6px; ' . ($i == $page ? 'background:#007bff; color:white;' : 'color:#007bff;') . '">' . $i . '</a>';
    }

    if ($page < $total_pages) {
        $pagination .= '<a href="#" data-page="' . ($page + 1) . '" style="margin-left:8px; color:#007bff;">Next <i class="fas fa-angle-right"></i></a>';
    }
}

echo json_encode([
    'html' => $html,
    'pagination' => $pagination
]);
