<?php
session_start();
include('connect.php');

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login.php");
    exit;
}

$phone_number = $_SESSION['phone_number'];

// Popup message logic
$popupResult = mysqli_query($con, "SELECT message FROM popup_messages ORDER BY id DESC LIMIT 1");
$popupRow = mysqli_fetch_assoc($popupResult);
$popupMessage = $popupRow['message'] ?? '';

$popupStatusResult = mysqli_query($con, "SELECT popup_shown FROM members WHERE phone_number = '$phone_number'");
$popupShownRow = mysqli_fetch_assoc($popupStatusResult);
$popupShown = $popupShownRow['popup_shown'];

if ($popupShown == 0 && !empty($popupMessage)) {
    echo "
<style>
    /* Global Themed Popup Box */
#popupBox {
    position: fixed;
    top: 50%; 
    left: 50%;
    transform: translate(-50%, -50%);
    background: linear-gradient(145deg, #1a1a1a, #333);
    border: 2px solid #d4af37;
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.5);
    padding: 20px 25px;
    z-index: 9999;
    max-width: 90%;
    width: 400px;
    animation: fadeIn 0.4s ease-in-out;
    color: white;
}

#popupBox p {
    font-size: 16px;
    color: #d4af37;
    margin-bottom: 20px;
    text-align: center;
}

#popupCloseBtn {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 20px;
    color: #d4af37;
    cursor: pointer;
    transition: color 0.3s ease;
}

#popupCloseBtn:hover {
    color: red;
}

#popupConfirmBtn {
    background: #d4af37;
    color: black;
    font-weight: bold;
    border: none;
    padding: 10px 20px;
    border-radius: 8px;
    cursor: pointer;
    display: block;
    margin: 0 auto;
    transition: all 0.3s ease;
}

#popupConfirmBtn:hover {
    background: #bfa238;
    transform: scale(1.05);
}

@keyframes fadeIn {
    from { opacity: 0; transform: translate(-50%, -60%); }
    to { opacity: 1; transform: translate(-50%, -50%); }
}
</style>

<div id='popupBox'>
    <span id='popupCloseBtn' onclick='closePopup()'>&times;</span>
    <p>$popupMessage</p>
    <button id='popupConfirmBtn' onclick='closePopup()'>Close</button>
</div>

<script>
    function closePopup() {
        document.getElementById('popupBox').style.display = 'none';
        fetch('update_popup_status.php', { method: 'POST' });
    }
</script>";
}

$member_result = mysqli_query($con, "SELECT * FROM members WHERE phone_number = '$phone_number'");
$member = mysqli_fetch_assoc($member_result);

$main_wallet = ($member['main_wallet'] > 0) ? number_format($member['main_wallet'], 2) : $member['main_wallet'];
$earning_wallet = ($member['earning_wallet'] > 0) ? number_format($member['earning_wallet'], 2) : $member['earning_wallet'];

$member_id = $member['member_id'];

$stats_result = mysqli_query($con, "SELECT 
    (SELECT COUNT(*) FROM user_tasks WHERE phone_number = '$phone_number') as total_tasks,
    (SELECT COUNT(*) FROM user_tasks WHERE phone_number = '$phone_number' AND is_correct = 1) as correct_answers,
    (SELECT COUNT(*) FROM user_tasks WHERE phone_number = '$phone_number' AND is_correct = 0) as wrong_answers
");
$stats = mysqli_fetch_assoc($stats_result);

$pkg_query = "SELECT p.package_name, up.package_end_date
              FROM user_packages up
              JOIN packages p ON p.level = up.level
              WHERE up.phone_number = '$phone_number'";
$pkg_result = mysqli_query($con, $pkg_query);

if (mysqli_num_rows($pkg_result) > 0) {
    $pkg_data = mysqli_fetch_assoc($pkg_result);
    $active_package = $pkg_data['package_name'];
    $package_end_date = $pkg_data['package_end_date']; // YYYY-MM-DD
} else {
    $active_package = "None";
    $package_end_date = null;
}

// Fetch packages
$packages = [];
$query = mysqli_query($con, "SELECT * FROM packages ORDER BY level ASC LIMIT 3");
while ($row = mysqli_fetch_assoc($query)) {
    $packages[] = $row;
}
?>

<?php include('header.php') ?>

<!-- Welcome banner -->
<div class="welcome-banner">
    <i class="fas fa-coins"></i>
    <span>Welcome back, <?php echo htmlspecialchars($member['first_name']); ?>!</span>
    <small>Let’s earn today with <strong>CashFunz</strong>!</small>
</div>

<!-- Font Awesome for Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    
<!-- Moving Text Section -->
<div class="moving-text-container">
  <p class="moving-text">
    🚀 Activate Package — Answer Questions — Start Earning Daily! 💰
  </p>
</div>

<br>
<div style="text-align: center; ">
  <a href="task.php" class="gold-btn">
    Start Earning &raquo;
  </a>
</div>

<style>
  .gold-btn {
    display: inline-block;
    background: linear-gradient(135deg, #d4af37, black);
    color: white;
    font-weight: 700;
    padding: 12px 24px;
    border-radius: 8px;
    text-decoration: none;
    box-shadow: 0 4px 12px rgba(212, 175, 55, 0.7);
    transition: background 0.3s ease, color 0.3s ease, transform 0.2s ease;
    font-size: 18px;
    user-select: none;
  }

  .gold-btn:hover {
    background: linear-gradient(135deg, black, #e6c230);
    color: #111;
    transform: translateY(-3px);
    box-shadow: 0 6px 20px rgba(255, 215, 0, 0.9);
  }
  .gold-btn {
  position: relative; /* make sure it’s positioned */
  z-index: 10000; /* very high, on top */
  pointer-events: auto; /* ensure pointer events allowed */
  cursor: pointer; /* show pointer on hover */
}

div[style*="text-align: center"] {
  position: relative;
  z-index: 10000;
  pointer-events: auto;
}

</style>



<!-- Dashboard Section -->
<div class="pt-120 pb-120">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-12">

        <!-- Dashboard Cards -->
        <div class="row mb-none-30 dashboard-cards">

          <div class="col-6 col-md-6 mb-30">
            <div class="card-box deposit">
              <div class="card-text">
                <span class="caption">Deposit Balance</span>
                <h4 class="currency-amount">₦<?php echo $main_wallet; ?></h4>
              </div>
              <div class="card-icon">
                <i class="las la-piggy-bank"></i>
              </div>
            </div>
          </div>

          <div class="col-6 col-md-6 mb-30">
            <div class="card-box earning">
              <div class="card-text">
                <span class="caption">Earning Balance</span>
                <h4 class="currency-amount">₦<?php echo $earning_wallet; ?></h4>
              </div>
              <div class="card-icon">
                <i class="las la-wallet"></i>
              </div>
            </div>
          </div>

       <div class="col-6 col-md-6 mb-30">
  <div class="card-box package">
    <div class="card-text">
      <span class="caption">Active Package</span>
      <h4 class="currency-amount">
        <?php echo htmlspecialchars($active_package); ?>
        <br>
        <?php if (!empty($package_end_date)): 
          // Format PHP date to ISO 8601 compatible string (YYYY-MM-DD)
          $jsDate = substr($package_end_date, 0, 10) . "T23:59:59";
        ?>
        
        <small id="countdown" style="font-size:0.7rem; margin-left:10px; color:#d9534f;"></small>

        <script>
          const phpDateStr = "<?php echo $jsDate; ?>";
          const packageEndDate = new Date(phpDateStr).getTime();

          function updateCountdown() {
            const now = new Date().getTime();
            const distance = packageEndDate - now;

            if (distance < 0) {
              document.getElementById('countdown').innerText = "(Expired)";
              clearInterval(timerInterval);
              return;
            }

            const days = Math.floor(distance / (1000 * 60 * 60 * 24));
            const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);

            document.getElementById('countdown').innerText =
              `(Renew in: ${days}d ${hours}h ${minutes}m ${seconds}s)`;
          }

          updateCountdown();
          const timerInterval = setInterval(updateCountdown, 1000);
        </script>

        <?php endif; ?>
      </h4>
    </div>
    <div class="card-icon">
      <i class="las la-box"></i>
    </div>
  </div>
</div>



          <div class="col-6 col-md-6 mb-30">
            <div class="card-box tasks">
              <div class="card-text">
                <span class="caption">Total Questions Attempt</span>
                <h4 class="currency-amount"><?php echo $stats['total_tasks']; ?></h4>
              </div>
              <div class="card-icon">
                <i class="las la-tasks"></i>
              </div>
            </div>
          </div>

          <div class="col-6 col-md-6 mb-30">
            <div class="card-box correct">
              <div class="card-text">
                <span class="caption">Correct Answers</span>
                <h4 class="currency-amount"><?php echo $stats['correct_answers']; ?></h4>
              </div>
              <div class="card-icon">
                <i class="las la-check-circle"></i>
              </div>
            </div>
          </div>

          <div class="col-6 col-md-6 mb-30">
            <div class="card-box wrong">
              <div class="card-text">
                <span class="caption">Wrong Answers</span>
                <h4 class="currency-amount"><?php echo $stats['wrong_answers']; ?></h4>
              </div>
              <div class="card-icon">
                <i class="las la-times-circle"></i>
              </div>
            </div>
          </div>

        </div>
        <!-- End Dashboard Cards -->

        <!-- Package Section -->
        <section class="pt-120 pb-120">
          <div class="container">
            <div class="row justify-content-center">
              <div class="col-lg-6 text-center">
                <div class="section-header">
                  <h2 class="section-title"><span class="font-weight-normal">Earning</span> <b class="base--color">Packages</b></h2>
                  <p>Pick the right plan for your earning goals. Each package comes with a set number of daily questions and earnings per answer.</p>
                </div>
              </div>
            </div>
            <div class="row justify-content-center mb-none-30">
              <?php foreach ($packages as $pkg): ?>
                <div class="col-xl-3 col-lg-4 col-md-6 mb-30">
                  <div class="package-card text-center bg_img" data-background="assets/images/bg/bg-4.png">
                    <h4 class="package-card__title base--color gold-gradient-header mb-2"><?= htmlspecialchars($pkg['package_name']) ?></h4>
                    <ul class="package-card__features mt-4">
                      <li>Question Limit: <?= $pkg['task_limit'] ?> / day</li>
                      <li>Earn per Answer: ₦<?= number_format($pkg['task_rate']) ?></li>
                      <li>Daily Earning: ₦<?= number_format($pkg['task_limit'] * $pkg['task_rate']) ?></li>
                      <li>Duration: <?= $pkg['duration'] ?>-Days</li>
                    </ul>
                    <div class="package-card__range mt-5 base--color">₦<?= number_format($pkg['activation_amount']) ?></div>
                    <a href="activate_package.php?id=<?= $pkg['id'] ?>" class="cmn-btn btn-md mt-4 gold-gradient-btn">Activate Package</a>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        </section>
        <!-- End Package Section -->

        <!-- Action Buttons -->
        <div class="action-cards">
          <a href="deposit.php" class="card-btn deposit">
            <i class="fas fa-arrow-down"></i>
            <span>Deposit Fund</span>
          </a>
          <a href="withdrawal.php" class="card-btn withdraw">
            <i class="fas fa-arrow-up"></i>
            <span>Withdraw Fund</span>
          </a>
          <a href="task.php" class="card-btn task">
            <i class="fas fa-play-circle"></i>
            <span>Start Task</span>
          </a>
          <a href="packages.php" class="card-btn task">
            <i class="fas fa-box-open"></i>
            <span>Explore Packages</span>
          </a>
        </div>
        <!-- End Action Buttons -->

      </div>
    </div>
  </div>
</div>
<!-- End Dashboard Section -->

<script>
function toggleMenu() {
  document.getElementById('menu').classList.toggle('show');
}

window.addEventListener('load', () => {
  document.querySelector('.preloader').style.display = 'none';
});

function copyReferralLink() {
  const input = document.getElementById("referralLink");
  input.select();
  input.setSelectionRange(0, 99999); 
  document.execCommand("copy");

  Swal.fire({
    icon: 'success',
    title: 'Copied!',
    text: 'Your referral link has been copied.',
    confirmButtonColor: '#007BFF'
  });
}
</script>

<style>
/* Dashboard cards container */
.dashboard-cards .card-box {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: linear-gradient(135deg, #000000, #333333) !important; /* black to dark gray gradient */
  color: #d4af37 !important; /* gold text */
  padding: 15px;
  border-radius: 10px;
  box-shadow: 0 4px 12px rgba(212, 175, 55, 0.8) !important; /* gold glow */
  transition: all 0.3s ease;
}

.dashboard-cards .card-box:hover {
  transform: translateY(-5px);
  box-shadow: 0 6px 16px rgba(212, 175, 55, 1) !important;
}

.dashboard-cards .caption {
  font-size: 14px;
  color: #FFD700 !important; /* brighter gold */
  display: block;
  margin-bottom: 5px;
}

.dashboard-cards .currency-amount {
  font-size: 20px;
  font-weight: bold;
  color: #FFD700 !important;
}

.dashboard-cards .card-icon {
  font-size: 28px;
  color: #FFD700 !important;
}

/* Specific cards background overrides */
.dashboard-cards .deposit {
  background: linear-gradient(135deg, #000000, #444444) !important;
}

.dashboard-cards .earning {
  background: linear-gradient(135deg, #000000, #555555) !important;
}

.dashboard-cards .package {
  background: linear-gradient(135deg, #000000, #333333) !important;
}

.dashboard-cards .tasks {
  background: linear-gradient(135deg, #000000, #444444) !important;
}

.dashboard-cards .correct {
  background: linear-gradient(135deg, #000000, #444444) !important;
}

.dashboard-cards .wrong {
  background: linear-gradient(135deg, #000000, #555555) !important;
}

@media (max-width: 768px) {
  .dashboard-cards .card-box {
    flex-direction: column;
    text-align: center;
  }
  .dashboard-cards .card-icon {
    margin-top: 10px;
  }
}

/* Action cards container */
.action-cards {
  display: flex;
  flex-wrap: wrap;
  gap: 15px;
  margin: 20px 0;
  justify-content: center;
}

.card-btn {
  flex: 1 1 45%;  /* two buttons per row */
  min-width: 0;   /* important: allow shrinking below content size */
  max-width: none;
  box-sizing: border-box;
  
  background: linear-gradient(145deg, #1a1a1a, #333333) !important;
  border: 1px solid #d4af37 !important;
  border-radius: 12px;
  color: #fff !important;
  padding: 15px 10px;
  text-align: center;
  font-weight: bold;
  text-decoration: none;
  box-shadow: 0 4px 10px rgba(212, 175, 55, 0.7) !important;
  transition: all 0.3s ease;
  cursor: pointer;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  height: 100%; /* ensure consistent height */
}

.card-btn i {
  font-size: 24px;
  margin-bottom: 5px;
  color: #d4af37 !important;
  display: block;
}




.card-btn:hover {
  box-shadow: 0 6px 15px rgba(212, 175, 55, 0.9) !important;
  transform: translateY(-3px);
}


/* Button border colors */
.card-btn.deposit,
.card-btn.withdraw,
.card-btn.task {
  border-color: #d4af37 !important;
}

/* Welcome banner */
.welcome-banner {
  background: #111111 !important;
  border: 1px solid #d4af37 !important;
  border-radius: 15px;
  padding: 15px 20px;
  text-align: center;
  color: #f5f5f5 !important;
  font-size: 18px;
  font-weight: 500;
  box-shadow: 0 0 15px rgba(212, 175, 55, 0.6) !important;
  animation: goldPulse 2s infinite ease-in-out;
  max-width: 300px;
  margin: 20px auto;
}

.welcome-banner i {
  color: #d4af37 !important;
  font-size: 22px;
  margin-right: 8px;
}

.welcome-banner small {
  display: block;
  font-size: 14px;
  font-weight: normal;
  margin-top: 4px;
  color: #ccc !important;
}

.welcome-banner strong {
  color: #d4af37 !important;
}

@keyframes goldPulse {
  0% { box-shadow: 0 0 8px rgba(212, 175, 55, 0.4); }
  50% { box-shadow: 0 0 16px rgba(212, 175, 55, 0.8); }
  100% { box-shadow: 0 0 8px rgba(212, 175, 55, 0.4); }
}

/* Moving Text */
.moving-text-container {
  width: 100%;
  overflow: hidden;
  background: linear-gradient(90deg, #d4af37, #000000, #555555);
  padding: 10px 0;
  border-radius: 8px;
  box-shadow: 0 3px 8px rgba(0,0,0,0.3);
}

.moving-text {
  display: inline-block;
  white-space: nowrap;
  font-size: 18px;
  font-weight: bold;
  color: white;
  animation: scrollText 12s linear infinite;
}

@keyframes scrollText {
  0% { transform: translateX(100%); }
  100% { transform: translateX(-100%); }
}

/* Package card header with gradient */
.gold-gradient-header {
  color: white;
  background: linear-gradient(90deg, #d4af37, #000000, #555555);
  padding: 6px 12px;
  border-radius: 6px;
  display: inline-block;
  font-weight: 600;
  text-shadow: 0 0 5px #d4af37;
}

/* Package activate button */
.gold-gradient-btn {
  color: white;
  background: linear-gradient(90deg, #d4af37, #000000, #555555);
  padding: 8px 12px;
  border-radius: 6px;
  display: inline-block;
  text-decoration: none;
  font-weight: bold;
  transition: background 0.3s ease;
}

.gold-gradient-btn:hover {
  background: linear-gradient(90deg, #ffd700, #222222, #777777);
}

/* Package card styling */
.package-card {
  background: #1a1a1a;
  padding: 20px 15px;
  border-radius: 12px;
  box-shadow: 0 5px 15px rgba(212,175,55,0.3);
  color: white;
  min-height: 310px;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
}

.package-card__features {
  list-style: none;
  padding-left: 0;
  margin-top: 15px;
  color: white;
  font-weight: 600;
  font-size: 15px;
  text-align: left;
}

.package-card__range {
  font-size: 20px;
  font-weight: bold;
  margin-top: 25px;
}

</style>


<?php include('footer.php')?>
