<?php
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}

include 'connect.php';

$id = $_GET['id'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $first_name = $_POST['first_name'];
    $last_name  = $_POST['last_name'];
    $phone      = $_POST['phone_number'];
    $email      = $_POST['email_address'];
    $country    = $_POST['country_of_interest'];
    $state      = $_POST['state_of_origin'];
    $nin        = $_POST['nin'];
    $marital    = $_POST['marital_status'];
    $dob        = $_POST['dob'];

    $stmt = $con->prepare("UPDATE members SET first_name=?, last_name=?, phone_number=?, email_address=?, country_of_interest=?, state_of_origin=?, nin=?, marital_status=?, dob=? WHERE id=?");
    $stmt->bind_param("sssssssssi", $first_name, $last_name, $phone, $email, $country, $state, $nin, $marital, $dob, $id);
    $stmt->execute();

    header("Location: member_list.php");
    exit();
}

$stmt = $con->prepare("SELECT * FROM members WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$member = $result->fetch_assoc();

include 'menu.php';
?>



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Edit member</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  
  <!-- Bootstrap CSS -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css"
    rel="stylesheet"
  />
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
  
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <style>
    body {
      background-color: #f1f4f9;
      font-family: "Segoe UI", sans-serif;
    }
    .container {
      padding-top: 30px;
    }
    .card {
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    }
    .table th, .table td {
      vertical-align: middle;
    }
    .btn-sm {
      padding: 4px 10px;
      font-size: 0.875rem;
    }
    .action-buttons a {
      margin-right: 5px;
    }
    .create-btn {
      margin-bottom: 15px;
    }
  </style>
</head>



<body class="bg-light">
<div class="container mt-5">
    <h3>Edit Member</h3>
    <form method="POST">
        <div class="mb-3"><label>First Name</label><input name="first_name" class="form-control" value="<?= htmlspecialchars($member['first_name']) ?>"></div>
        <div class="mb-3"><label>Last Name</label><input name="last_name" class="form-control" value="<?= htmlspecialchars($member['last_name']) ?>"></div>
        <div class="mb-3"><label>Phone Number</label><input name="phone_number" class="form-control" value="<?= htmlspecialchars($member['phone_number']) ?>"></div>
        <div class="mb-3"><label>Email</label><input name="email_address" class="form-control" value="<?= htmlspecialchars($member['email_address']) ?>"></div>
        <div class="mb-3"><label>Country of Interest</label><input name="country_of_interest" class="form-control" value="<?= htmlspecialchars($member['country_of_interest']) ?>"></div>
        <div class="mb-3"><label>State of Origin</label><input name="state_of_origin" class="form-control" value="<?= htmlspecialchars($member['state_of_origin']) ?>"></div>
        <div class="mb-3"><label>NIN</label><input name="nin" class="form-control" value="<?= htmlspecialchars($member['nin']) ?>"></div>
        <div class="mb-3"><label>Marital Status</label><input name="marital_status" class="form-control" value="<?= htmlspecialchars($member['marital_status']) ?>"></div>
        <div class="mb-3"><label>Date of Birth</label><input type="date" name="dob" class="form-control" value="<?= htmlspecialchars($member['dob']) ?>"></div>

        <button type="submit" class="btn btn-success">Update</button>
        <a href="all_members.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>
</body>
</html>