<?php
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}


// Include config file
require_once "config.php";
 include('connect.php');
 
 /*
///////////select user details
$sql2 ="SELECT * FROM members WHERE phone_number={$_SESSION['phone_number']}";   
$result2 = mysqli_query($con, $sql2);
$data2 = mysqli_fetch_array($result2);
$first_name = $data2['first_name'];
$last_name = $data2['last_name'];
$phone_number = $data2['phone_number'];
$email_address= $data2['email_address'];
$sponsor_id= $data2['sponsor_id'];
$member_id= $data2['member_id'];
$main_wallet= $data2['main_wallet'];
$earning_wallet= $data2['earning_wallet'];
$email_verification_status= $data2['email_verification_status'];
$payment_status= $data2['payment_status'];
$package_level= $data2['package_level'];
*/



// Handle approve/decline actions
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
  $id = $_POST['id'];
  $action = $_POST['action'];

  // Fetch deposit details
  $req = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM deposits WHERE id='$id'"));
  $amount = $req['amount'];
  $phone = $req['phone_number'];
  $current_status = strtolower($req['status']);

  if ($action == 'approve' && $current_status == 'pending') {
    mysqli_query($con, "UPDATE members SET main_wallet = main_wallet + $amount WHERE phone_number='$phone'");
    mysqli_query($con, "UPDATE deposits SET status='approved' WHERE id='$id'");
    $alert = "approved";
  } elseif ($action == 'decline' && $current_status == 'pending') {
    mysqli_query($con, "UPDATE deposits SET status='declined' WHERE id='$id'");
    $alert = "declined";
  } else {
    $alert = "processed";
  }
}
$deposits = mysqli_query($con, "SELECT * FROM deposits ORDER BY date_submitted DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Admin - Deposit Approvals</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
  body {
    font-family: Arial, sans-serif;
    background: linear-gradient(135deg, #1c1c1c, #2e2e2e);
    margin: 0;
    color: #d4af37;
  }
  header {
    background: linear-gradient(to right, gold, black);
    color: #fff;
    padding: 1em;
    text-align: center;
    position: relative;
    box-shadow: 0 3px 8px rgba(0, 0, 0, 0.6);
  }
  .hamburger {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 22px;
    cursor: pointer;
    color: gold;
  }
  .container {
    max-width: 1000px;
    margin: 20px auto;
    background: linear-gradient(145deg, #3a3a3a, #2b2b2b);
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 0 15px rgba(212, 175, 55, 0.5);
    color: #d4af37;
  }
  table {
    width: 100%;
    border-collapse: collapse;
    overflow-x: auto;
    display: block;
  }
  th, td {
    padding: 10px;
    border: 1px solid #555;
    text-align: center;
  }
  th {
    background: linear-gradient(to right, gold, black);
    color: #fff;
  }
  button {
    padding: 5px 10px;
    border: none;
    color: white;
    border-radius: 5px;
    cursor: pointer;
    font-weight: bold;
    box-shadow: 0 2px 5px rgba(212, 175, 55, 0.6);
    transition: background-color 0.3s ease;
  }
  .approve {
    background: linear-gradient(to right, #b8860b, #ffd700);
    color: #222;
  }
  .approve:hover {
    background: gold;
    color: black;
  }
  .decline {
    background: linear-gradient(to right, #660000, #a00000);
  }
  .decline:hover {
    background: #ff3333;
  }
  .status-approved {
    color: #b8860b;
    font-weight: bold;
  }
  .status-declined {
    color: #a00000;
    font-weight: bold;
  }
  .status-pending {
    color: #d4af37;
    font-weight: bold;
  }
  footer {
    background: linear-gradient(to right, black, gold);
    color: white;
    text-align: center;
    padding: 10px;
    position: fixed;
    bottom: 0;
    width: 100%;
    box-shadow: 0 -2px 10px rgba(212, 175, 55, 0.7);
  }
  #preloader {
    position: fixed;
    top: 0; left: 0; right: 0; bottom: 0;
    background: #1c1c1c;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
  }
  @media (max-width: 768px) {
    th, td {
      font-size: 14px;
    }
  }
</style>

</head>
<body>
<div id="preloader"><i class="fas fa-spinner fa-spin fa-3x"></i></div>
<header>
  <div class="hamburger" onclick="toggleMenu()"><i class="fas fa-bars"></i></div>
  Admin - Deposit Approvals
</header>




<?php if ($alert == "approved") { ?>
<script>
  Swal.fire({
    icon: 'success',
    title: 'Deposit approved and wallet credited!',
    confirmButtonText: 'OK'
  });
</script>
<?php } elseif ($alert == "declined") { ?>
<script>
  Swal.fire({
    icon: 'info',
    title: 'Deposit declined.',
    confirmButtonText: 'OK'
  });
</script>
<?php } elseif ($alert == "processed") { ?>
<script>
  Swal.fire({
    icon: 'warning',
    title: 'This request was already processed.',
    confirmButtonText: 'OK'
  });
</script>
<?php } ?>


<div class="container">
  <h2><i class="fas fa-money-check-alt"></i> Pending Deposit Requests</h2>
  <table>
    <thead>
      <tr>
        <th>User</th>
        <th>Amount</th>
        <th>Depositor</th>
        <th>Proof</th>
        <th>Status</th>
        <th>Date</th>
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
    <?php while ($d = mysqli_fetch_assoc($deposits)) { ?>
      <tr>
        <td><?= $d['phone_number'] ?></td>
        <td>₦<?= number_format($d['amount'], 2) ?></td>
        <td><?= $d['depositor'] ?></td>
        <td><a href="../uploads/<?= $d['proof'] ?>" target="_blank">View</a></td>
        <td class="status-<?= strtolower($d['status']) ?>"><?= ucfirst($d['status']) ?></td>
        <td><?= date("d M Y, h:i A", strtotime($d['date_submitted'])) ?></td>
        <td>
          <?php if ($d['status'] == 'pending') { ?>
            <form method="POST" style="display:inline;">
              <input type="hidden" name="id" value="<?= $d['id'] ?>">
              <button class="approve" name="action" value="approve">Approve</button>
              <button class="decline" name="action" value="decline">Decline</button>
            </form>
          <?php } else { echo "-"; } ?>
        </td>
      </tr>
    <?php } ?>
    </tbody>
  </table>
</div>

<footer>
  &copy; <?= date("Y") ?> CashFunz
</footer>

<script>
  window.addEventListener('load', () => {
    document.getElementById('preloader').style.display = 'none';
    <?php if (isset($success)) { ?>
      Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: 'Action processed successfully.',
        confirmButtonText: 'OK',
        confirmButtonColor: '#007bff'
      });
    <?php } ?>
  });
  function toggleMenu() {
    alert("Hamburger clicked - add menu logic here if needed");
  }
</script>
</body>
</html>
