<?php
session_start();
include("connect.php");

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}

$phone_number = $_SESSION["phone_number"];
$message = "";
$message_type = "";

// Fetch user and pin data
$user_query = mysqli_query($con, "SELECT * FROM members WHERE phone_number='" . mysqli_real_escape_string($con, $phone_number) . "' LIMIT 1");
$user = mysqli_fetch_assoc($user_query);

$pin_query = mysqli_query($con, "SELECT * FROM withdraw_pins WHERE phone_number='" . mysqli_real_escape_string($con, $phone_number) . "' LIMIT 1");
$pin_data = mysqli_fetch_assoc($pin_query);
$withdraw_pin = $pin_data['pin'] ?? null;

// Handle set PIN (if none exists)
if (isset($_POST['set_pin'])) {
    $new_pin = trim($_POST['new_pin'] ?? '');
    if (preg_match('/^\d{4}$/', $new_pin)) {
        $hashed_pin = password_hash($new_pin, PASSWORD_DEFAULT);
        if ($pin_data) {
            $stmt = $con->prepare("UPDATE withdraw_pins SET pin = ? WHERE phone_number = ?");
            $stmt->bind_param("ss", $hashed_pin, $phone_number);
            $ok = $stmt->execute();
            $stmt->close();
        } else {
            $stmt = $con->prepare("INSERT INTO withdraw_pins (phone_number, pin) VALUES (?, ?)");
            $stmt->bind_param("ss", $phone_number, $hashed_pin);
            $ok = $stmt->execute();
            $stmt->close();
        }
        if ($ok) {
            $message = "Withdrawal PIN set successfully.";
            $message_type = "success";
            $withdraw_pin = $hashed_pin;
        } else {
            $message = "Failed to set withdrawal PIN. Please try again.";
            $message_type = "error";
        }
    } else {
        $message = "PIN must be a 4-digit number.";
        $message_type = "error";
    }
}

// Handle reset PIN (if exists)
if (isset($_POST['reset_pin'])) {
    $account_password = $_POST['account_password'] ?? '';
    if (isset($user['password']) && password_verify($account_password, $user['password'])) {
        $new_pin = trim($_POST['reset_new_pin'] ?? '');
        if (preg_match('/^\d{4}$/', $new_pin)) {
            $hashed_new_pin = password_hash($new_pin, PASSWORD_DEFAULT);
            $stmt = $con->prepare("UPDATE withdraw_pins SET pin = ? WHERE phone_number = ?");
            $stmt->bind_param("ss", $hashed_new_pin, $phone_number);
            $ok = $stmt->execute();
            $stmt->close();
            if ($ok) {
                $message = "Withdrawal PIN reset successfully.";
                $message_type = "success";
                $withdraw_pin = $hashed_new_pin;
            } else {
                $message = "Failed to reset PIN. Try again.";
                $message_type = "error";
            }
        } else {
            $message = "PIN must be a 4-digit number.";
            $message_type = "error";
        }
    } else {
        $message = "Incorrect account password.";
        $message_type = "error";
    }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Set or Reset Withdrawal PIN</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
    body {
        margin: 0;
        font-family: 'Segoe UI', sans-serif;
        background: #1c1c1c; /* dark background */
        color: #ddd;
    }
    header, footer {
        background: linear-gradient(135deg, black, #805c00); /* gold-black gradient */
        color: #d4af37; /* gold text */
        text-align: center;
        padding: 15px;
        font-weight: 700;
        letter-spacing: 1px;
        text-shadow: 0 0 5px rgba(191,160,74,0.8);
        box-shadow: 0 3px 6px rgba(0,0,0,0.7);
    }
    .container {
        max-width: 400px;
        margin: 40px auto;
        padding: 30px;
        background: #2e2e2e; /* dark gray container */
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(191,160,74,0.7); /* soft golden glow */
        color: #eee;
    }
    h2 {
        text-align: center;
        color: #d4af37; /* gold */
        text-shadow: 0 0 8px #bfa04a;
        margin-bottom: 20px;
    }
    input {
        width: 100%;
        padding: 12px;
        margin: 8px 0 20px;
        border-radius: 6px;
        border: 1.5px solid #bfa04a; /* gold border */
        background: #444; /* dark input background */
        color: #eee;
        font-weight: 600;
        box-shadow: inset 0 0 6px rgba(191,160,74,0.4);
        transition: border-color 0.3s ease;
    }
    input:focus {
        border-color: #d4af37;
        outline: none;
        box-shadow: 0 0 8px #d4af37;
        background: #555;
        color: #fff;
    }
    button.submit-btn {
        width: 100%;
        padding: 14px;
        background: linear-gradient(135deg, black, #805c00);
        color: white;
        border: none;
        font-size: 16px;
        border-radius: 6px;
        cursor: pointer;
        font-weight: 700;
        box-shadow: 0 5px 15px rgba(191,160,74,0.7);
        transition: background 0.3s ease, transform 0.2s ease;
        text-shadow: 0 0 5px #bfa04a;
    }
    button.submit-btn:hover {
        background: linear-gradient(135deg, #bfa04a, #805c00);
        color: black;
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(191,160,74,0.9);
    }
</style>

</head>
<body>
<header>
    <h1><i class="fas fa-key"></i> Withdrawal PIN</h1>
</header>

<div class="container">
    <?php if (empty($withdraw_pin)): ?>
        <form method="POST" id="setPinForm">
            <label>Set 4-digit Withdrawal PIN</label>
            <input type="password" name="new_pin" required pattern="\d{4}" maxlength="4" placeholder="Enter 4-digit PIN">
            <button class="submit-btn" type="submit" name="set_pin"><i class="fas fa-lock"></i> Set PIN</button>
        </form>
    <?php else: ?>
        <form method="POST" id="resetPinForm">
            <h3><i class="fas fa-sync"></i> Reset Withdrawal PIN</h3>
            <input type="password" name="account_password" placeholder="Your Account Password" required>
            <input type="password" name="reset_new_pin" placeholder="New 4-digit PIN" required maxlength="4">
            <button class="submit-btn" type="submit" name="reset_pin"><i class="fas fa-sync"></i> Reset PIN</button>
        </form>
    <?php endif; ?>

    <?php if (!empty($message)): ?>
        <script>
            document.addEventListener("DOMContentLoaded", function(){
                Swal.fire({
                    icon: '<?= $message_type === "success" ? "success" : "error" ?>',
                    title: '<?= $message_type === "success" ? "Success" : "Error" ?>',
                    html: '<?= nl2br(htmlspecialchars($message, ENT_QUOTES)) ?>'
                }).then(() => {
                    if ('<?= $message_type ?>' === 'success') {
                        window.location.href = 'withdrawal.php';
                    }
                });
            });
        </script>
    <?php endif; ?>
</div>

<footer>
    <p>&copy; <?= date('Y') ?> <?= htmlspecialchars($_SERVER['HTTP_HOST']) ?>. All rights reserved.</p>
</footer>
</body>
</html>
