<?php
include 'connect.php';

// Handle form submission
if (isset($_POST['update'])) {
    $message = mysqli_real_escape_string($con, $_POST['message']);
    mysqli_query($con, "INSERT INTO popup_messages (message) VALUES ('$message')");
    mysqli_query($con, "UPDATE members SET popup_shown = 0"); // Reset popup for all users
    echo "<script>alert('Popup updated!'); window.location='update_popup.php';</script>";
}

// Fetch latest message
$latest = mysqli_fetch_assoc(mysqli_query($con, "SELECT message FROM popup_messages ORDER BY id DESC LIMIT 1"));
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin - Update Popup</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <!-- Style -->
    <style>
    body {
        margin: 0;
        font-family: Arial, sans-serif;
        background: linear-gradient(135deg, #1c1c1c, #2e2e2e);
        color: #d4af37;
    }

    header {
        background: linear-gradient(to right, gold, black);
        color: white;
        padding: 15px 20px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        box-shadow: 0 3px 8px rgba(212, 175, 55, 0.6);
    }

    .logo {
        font-size: 20px;
        font-weight: bold;
        color: #ffd700;
    }

    .menu-toggle {
        display: none;
        font-size: 24px;
        cursor: pointer;
        color: gold;
    }

    nav {
        background: #2c2c2c;
        display: flex;
        flex-direction: row;
        gap: 20px;
        padding: 10px 20px;
        border-radius: 0 0 8px 8px;
        box-shadow: inset 0 -2px 5px rgba(212,175,55,0.3);
    }

    nav a {
        color: #d4af37;
        text-decoration: none;
        font-weight: bold;
        transition: color 0.3s ease;
    }

    nav a:hover {
        color: gold;
        text-shadow: 0 0 5px gold;
    }

    .container {
        padding: 20px;
        max-width: 800px;
        margin: 30px auto;
        background: linear-gradient(145deg, #3a3a3a, #2b2b2b);
        border-radius: 8px;
        box-shadow: 0 0 15px rgba(212, 175, 55, 0.4);
        color: #d4af37;
    }

    textarea {
        width: 100%;
        padding: 10px;
        font-size: 16px;
        border: 1px solid #555;
        border-radius: 6px;
        resize: vertical;
        background: #1c1c1c;
        color: #d4af37;
        box-shadow: inset 0 0 5px rgba(212,175,55,0.5);
        transition: border-color 0.3s ease;
    }

    textarea:focus {
        border-color: gold;
        outline: none;
        box-shadow: 0 0 8px gold;
    }

    button {
        background: linear-gradient(90deg, gold, black);
        color: black;
        padding: 10px 20px;
        margin-top: 10px;
        border: none;
        border-radius: 6px;
        font-size: 16px;
        cursor: pointer;
        font-weight: bold;
        box-shadow: 0 4px 10px rgba(212, 175, 55, 0.7);
        transition: background 0.3s ease, color 0.3s ease;
    }

    button:hover {
        background: gold;
        color: black;
        box-shadow: 0 6px 15px rgba(212, 175, 55, 1);
    }

    footer {
        text-align: center;
        padding: 15px;
        background: linear-gradient(to right, black, gold);
        color: #fff;
        margin-top: 40px;
        box-shadow: 0 -3px 8px rgba(212, 175, 55, 0.6);
    }

    @media (max-width: 768px) {
        .menu-toggle {
            display: block;
            color: gold;
        }

        nav {
            flex-direction: column;
            display: none;
        }

        nav.active {
            display: flex;
        }
    }
</style>

</head>
<body>

<header>
    <div class="logo"><i class="fas fa-cog"></i> Admin Panel</div>
    <div class="menu-toggle" onclick="toggleMenu()"><i class="fas fa-bars"></i></div>
</header>

<nav id="adminMenu">
   <!-- <a href="dashboard.php"><i class="fas fa-home"></i> Home</a>--->
    <a href="dashboard.php"><i class="fas fa-bell"></i> Dashboard</a>
   <!-- <a href="manage_users.php"><i class="fas fa-users"></i> Manage Users</a>-->
    <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
</nav>

<div class="container">
    <h2><i class="fas fa-bell"></i> Update Dashboard Popup</h2>
    <form method="post">
        <label for="message">Popup Message:</label><br>
        <textarea name="message" rows="5"><?= htmlspecialchars($latest['message'] ?? '') ?></textarea><br>
        <button type="submit" name="update"><i class="fas fa-paper-plane"></i> Update Message</button>
    </form>
</div>

<footer>
    &copy; <?= date('Y') ?> City SME Projects Admin
</footer>

<script>
    function toggleMenu() {
        document.getElementById('adminMenu').classList.toggle('active');
    }
</script>

</body>
</html>
