<?php
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}

include 'connect.php';



// Handle search query
$search = '';
if (isset($_GET['search'])) {
    $search = mysqli_real_escape_string($con, $_GET['search']);
}

// Pagination setup
$limit = 10; // rows per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Count total rows
$count_sql = "SELECT COUNT(*) FROM members WHERE phone_number LIKE '%$search%' OR email_address LIKE '%$search%'";
$total_result = mysqli_query($con, $count_sql);
$total_rows = mysqli_fetch_array($total_result)[0];
$total_pages = ceil($total_rows / $limit);

// Fetch paginated results
$query = "SELECT * FROM members WHERE phone_number LIKE ? OR email_address LIKE ? ORDER BY id DESC";
$stmt = $con->prepare($query);
$searchParam = "%$search%";
$stmt->bind_param("ss", $searchParam, $searchParam);
$stmt->execute();
$result = $stmt->get_result();

include 'menu.php';
?>



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>member List</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  
  <!-- Bootstrap CSS -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css"
    rel="stylesheet"
  />
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
  
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  
  <style>
  body {
    background: linear-gradient(135deg, #1c1c1c, #2e2e2e);
    font-family: "Segoe UI", sans-serif;
    color: #d4af37;
  }
  .container {
    padding-top: 30px;
    max-width: 1200px;
    margin: 0 auto;
  }
  .card {
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(212, 175, 55, 0.3);
    background: linear-gradient(145deg, #3a3a3a, #2b2b2b);
    padding: 20px;
    color: #d4af37;
  }
  .table th, .table td {
    vertical-align: middle;
    border-color: #555;
    border-style: solid;
    border-width: 1px;
  }
  .table th {
    background: linear-gradient(to right, gold, black);
    color: #fff;
  }
  .btn-sm {
    padding: 4px 10px;
    font-size: 0.875rem;
    border-radius: 6px;
    font-weight: 600;
    cursor: pointer;
    transition: background-color 0.3s ease;
  }
  .btn-sm:hover {
    filter: brightness(1.1);
  }
  .action-buttons a {
    margin-right: 5px;
  }
  .create-btn {
    margin-bottom: 15px;
    background: linear-gradient(90deg, gold, black);
    color: #111;
    font-weight: bold;
    padding: 8px 15px;
    border-radius: 8px;
    text-decoration: none;
    display: inline-block;
    box-shadow: 0 3px 8px rgba(212, 175, 55, 0.6);
    transition: background-color 0.3s ease;
  }
  .create-btn:hover {
    background: gold;
    color: black;
  }
</style>

</head>


<body class="bg-light">
<div class="container py-4">
    <h3 class="mb-4">All Registered Members</h3>

    <form method="get" class="row mb-3">
        <div class="col-md-4">
            <input type="text" name="search" class="form-control" placeholder="Search by phone or email" value="<?php echo htmlspecialchars($search); ?>">
        </div>
        <div class="col-md-2">
            <button class="btn btn-primary">Search</button>
        </div>
    </form>

     <div class="table-responsive">
        <table class="table table-bordered table-hover table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Phone</th>
                    <th>Email</th>
                    <th>Name</th>
                   <!-- <th>Country</th>
                    <th>State</th>
                    <th>NIN</th>
                    <th>Marital Status</th>
                    <th>DOB</th>
                    <th>Action</th>--->
                </tr>
            </thead>
            <tbody>
                <?php while($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['phone_number']) ?></td>
                    <td><?= htmlspecialchars($row['email_address']) ?></td>
                    <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) ?></td>
                    <!---
                    <td><?= htmlspecialchars($row['country_of_interest']) ?></td>
                    <td><?= htmlspecialchars($row['state_of_origin']) ?></td>
                    <td><?= htmlspecialchars($row['nin']) ?></td>
                    <td><?= htmlspecialchars($row['marital_status']) ?></td>
                    <td><?= htmlspecialchars($row['dob']) ?></td>
                    <td>
                        <a href="edit_member.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Edit</a>
                        <a href="delete_member.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>--->
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>


    <!-- Pagination links -->
    <nav>
        <ul class="pagination justify-content-center">
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <li class="page-item <?php if ($i == $page) echo 'active'; ?>">
                    <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>"><?php echo $i; ?></a>
                </li>
            <?php endfor; ?>
        </ul>
    </nav>
</div>
</body>
</html>