<?php
// Database connection
// Initialize the session
session_start();
 
// Check if the user is logged in, if not then redirect him/her to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}


// Include config file
//require_once "config.php";
 include('connect.php');
 
include 'menu.php';

$success = $error = "";
$id = $_GET['id'] ?? null;

if (!$id) {
    die("No package ID provided.");
}

// Fetch current data
$stmt = $con->prepare("SELECT * FROM packages WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$package = $result->fetch_assoc();

if (!$package) {
    die("Package not found.");
}

// Handle form update
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $package_name = trim($_POST["package_name"]);
    $activation_amount = $_POST["activation_amount"];
    $task_rate = $_POST["task_rate"];
    $task_limit = $_POST["task_limit"];

    $update = $con->prepare("UPDATE packages SET package_name=?, activation_amount=?, task_rate=?, task_limit=? WHERE id=?");
    $update->bind_param("sddii", $package_name, $activation_amount, $task_rate, $task_limit, $id);

    if ($update->execute()) {
        $success = "Package updated successfully.";
        // Reload latest values
        $package['package_name'] = $package_name;
        $package['activation_amount'] = $activation_amount;
        $package['task_rate'] = $task_rate;
        $package['task_limit'] = $task_limit;
    } else {
        $error = "Error updating package: " . $update->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     
    <title>Edit Package</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link
  href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css"
  rel="stylesheet"
/>
    <style>
        body { background: #f4f6f8; }
        .container { max-width: 600px; margin: 60px auto; }
        .card { border-radius: 12px; box-shadow: 0 5px 15px rgba(0,0,0,0.1); }
    </style>
</head>
<body>
    <div class="container">
        <div class="card p-4">
             <img src="logoc.png" style="width:120px;height:auto;" alt="Logo" />
             <br>
            <h3 class="mb-4 text-center">Update Package</h3>
            <?php if ($success): ?>
                <div class="alert alert-success"><?= $success ?></div>
            <?php elseif ($error): ?>
                <div class="alert alert-danger"><?= $error ?></div>
            <?php endif; ?>
            <form method="post">
                <div class="mb-3">
                    <label for="package_name" class="form-label">Package Name</label>
                    <input type="text" class="form-control" name="package_name" id="package_name" value="<?= htmlspecialchars($package['package_name']) ?>" required>
                </div>
                <div class="mb-3">
                    <label for="activation_amount" class="form-label">Activation Amount (₦)</label>
                    <input type="number" step="0.01" class="form-control" name="activation_amount" value="<?= htmlspecialchars($package['activation_amount']) ?>" required>
                </div>
                <div class="mb-3">
                    <label for="task_rate" class="form-label">Task Rate (₦)</label>
                    <input type="number" step="0.01" class="form-control" name="task_rate" value="<?= htmlspecialchars($package['task_rate']) ?>" required>
                </div>
                <div class="mb-3">
                    <label for="task_limit" class="form-label">Task Limit</label>
                    <input type="number" class="form-control" name="task_limit" value="<?= htmlspecialchars($package['task_limit']) ?>" required>
                </div>
                <button type="submit" class="btn btn-warning w-100">Update Package</button>
            </form>
        </div>
    </div>
    
      <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
      
</body>
</html>
